/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSTestSupport;
import org.springframework.context.ApplicationContext;

public class GetMapOutputFormatTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetMapOutputFormatTest());
    }

    public void testGetOutputFormatNames() {
        List producers = WMSExtensions.findMapProducers((ApplicationContext)applicationContext);
        for (GetMapOutputFormat producer : producers) {
            Set outputFormats = producer.getOutputFormatNames();
            GetMapOutputFormatTest.assertNotNull((Object)outputFormats);
            GetMapOutputFormatTest.assertTrue((outputFormats.size() > 0 ? 1 : 0) != 0);
            for (String oformat : outputFormats) {
                GetMapOutputFormatTest.assertNotNull((Object)oformat);
            }
        }
    }

    public void testGetOutputFormat() {
        List producers = WMSExtensions.findMapProducers((ApplicationContext)applicationContext);
        for (GetMapOutputFormat producer : producers) {
            GetMapOutputFormatTest.assertNotNull((Object)producer.getMimeType());
        }
    }

    public void testSetOutputFormat() {
        List producers = WMSExtensions.findMapProducers((ApplicationContext)applicationContext);
        for (GetMapOutputFormat producer : producers) {
            GetMapOutputFormatTest.assertNotNull((Object)producer.getMimeType());
            GetMapOutputFormatTest.assertNotNull((Object)producer.getOutputFormatNames());
            GetMapOutputFormatTest.assertTrue((producer.getOutputFormatNames().size() > 0 ? 1 : 0) != 0);
        }
    }
}

