/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.capabilities.CapabilitiesKvpReader;

public class CapabilitiesKvpReaderTest
extends TestCase {
    private CapabilitiesKvpReader reader;
    private HashMap kvp;
    private HashMap rawKvp;

    public void setUp() {
        this.reader = new CapabilitiesKvpReader(new WMS(null));
        this.kvp = new HashMap();
        this.rawKvp = new HashMap();
    }

    public void testDefault() throws Exception {
        this.rawKvp.put("request", "getcapabilities");
        this.kvp.put("request", "getcapabilities");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        CapabilitiesKvpReaderTest.assertNotNull((Object)read);
        CapabilitiesKvpReaderTest.assertEquals((String)"getcapabilities", (String)read.getRequest().toLowerCase());
        CapabilitiesKvpReaderTest.assertNull((Object)read.getBaseUrl());
        CapabilitiesKvpReaderTest.assertNull((Object)read.getNamespace());
    }

    public void testWMTVER() throws Exception {
        this.rawKvp.put("WMTVER", "1.0");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        CapabilitiesKvpReaderTest.assertNotNull((Object)read);
        CapabilitiesKvpReaderTest.assertEquals((String)"1.1.1", (String)read.getVersion());
    }

    public void testVersion() throws Exception {
        this.kvp.put("Version", "1.1.1");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        CapabilitiesKvpReaderTest.assertNotNull((Object)read);
        CapabilitiesKvpReaderTest.assertEquals((String)"1.1.1", (String)read.getVersion());
    }

    public void testNamespace() throws Exception {
        this.kvp.put("namespace", "og");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        CapabilitiesKvpReaderTest.assertNotNull((Object)read);
        CapabilitiesKvpReaderTest.assertEquals((String)"og", (String)read.getNamespace());
    }

    public void testUpdateSequence() throws Exception {
        this.kvp.put("updateSequence", "1000");
        GetCapabilitiesRequest read = this.reader.read(this.reader.createRequest(), (Map)this.kvp, (Map)this.rawKvp);
        CapabilitiesKvpReaderTest.assertNotNull((Object)read);
        CapabilitiesKvpReaderTest.assertEquals((String)"1000", (String)read.getUpdateSequence());
    }
}

