/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.describelayer.DescribeLayerKvpRequestReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeLayerKvpRequestReaderTest
extends TestCase {
    private GeoServerImpl geoServerImpl;
    private WMS wms;
    private Map<String, String> params;

    protected void setUp() throws Exception {
        this.geoServerImpl = new GeoServerImpl();
        this.geoServerImpl.add((ServiceInfo)new WMSInfoImpl());
        this.wms = new WMS((GeoServer)this.geoServerImpl);
        this.params = new HashMap<String, String>();
    }

    protected void tearDown() throws Exception {
        this.wms = null;
        this.params = null;
    }

    private DescribeLayerRequest getRequest(Map<String, String> rawKvp) throws Exception {
        return this.getRequest(rawKvp, new HashMap<String, Object>(rawKvp));
    }

    private DescribeLayerRequest getRequest(Map<String, String> rawKvp, Map<String, Object> kvp) throws Exception {
        DescribeLayerKvpRequestReader reader = new DescribeLayerKvpRequestReader(this.wms);
        DescribeLayerRequest req = (DescribeLayerRequest)reader.createRequest();
        return (DescribeLayerRequest)reader.read((Object)req, kvp, rawKvp);
    }

    public void testGetRequestNoVersion() throws Exception {
        this.params.put("LAYERS", "topp:states");
        try {
            this.getRequest(this.params);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected ServiceException if version is not provided");
        }
        catch (ServiceException e) {
            DescribeLayerKvpRequestReaderTest.assertEquals((String)"NoVersionInfo", (String)e.getCode());
        }
    }

    public void testGetRequestInvalidVersion() throws Exception {
        this.params.put("LAYERS", "topp:states");
        this.params.put("VERSION", "fakeVersion");
        try {
            this.getRequest(this.params);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected ServiceException if the wrong version is requested");
        }
        catch (ServiceException e) {
            DescribeLayerKvpRequestReaderTest.assertEquals((String)"InvalidVersion", (String)e.getCode());
        }
    }

    public void testGetRequestNoLayerRequested() throws Exception {
        this.params.put("VERSION", "1.1.1");
        try {
            this.getRequest(this.params);
            DescribeLayerKvpRequestReaderTest.fail((String)"expected ServiceException if no layer is requested");
        }
        catch (ServiceException e) {
            DescribeLayerKvpRequestReaderTest.assertEquals((String)"NoLayerRequested", (String)e.getCode());
        }
    }

    public void testGetRequest() throws Exception {
        CatalogImpl catalog = new CatalogImpl();
        this.geoServerImpl.setCatalog((Catalog)catalog);
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setPrefix("topp");
        ns.setURI("http//www.geoserver.org");
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setId("fakeWs");
        workspace.setName("fakeWs");
        DataStoreInfoImpl dataStoreInfo = new DataStoreInfoImpl((Catalog)catalog);
        dataStoreInfo.setName("fakeDs");
        dataStoreInfo.setId("fakeDs");
        dataStoreInfo.setWorkspace((WorkspaceInfo)workspace);
        FeatureTypeInfoImpl featureTypeInfo = new FeatureTypeInfoImpl((Catalog)catalog);
        featureTypeInfo.setNamespace((NamespaceInfo)ns);
        featureTypeInfo.setName("states");
        featureTypeInfo.setStore((StoreInfo)dataStoreInfo);
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setResource((ResourceInfo)featureTypeInfo);
        layerInfo.setId("states");
        layerInfo.setName("states");
        catalog.add((NamespaceInfo)ns);
        catalog.add((WorkspaceInfo)workspace);
        catalog.add((StoreInfo)dataStoreInfo);
        catalog.add((ResourceInfo)featureTypeInfo);
        catalog.add((LayerInfo)layerInfo);
        this.params.put("VERSION", "1.1.1");
        CoverageStoreInfoImpl coverageStoreInfo = new CoverageStoreInfoImpl((Catalog)catalog);
        coverageStoreInfo.setId("coverageStore");
        coverageStoreInfo.setName("coverageStore");
        coverageStoreInfo.setWorkspace((WorkspaceInfo)workspace);
        CoverageInfoImpl coverageInfo = new CoverageInfoImpl((Catalog)catalog);
        coverageInfo.setNamespace((NamespaceInfo)ns);
        coverageInfo.setName("fakeCoverage");
        coverageInfo.setStore((StoreInfo)coverageStoreInfo);
        LayerInfoImpl layerInfo2 = new LayerInfoImpl();
        layerInfo2.setResource((ResourceInfo)coverageInfo);
        layerInfo2.setId("fakeCoverage");
        layerInfo2.setName("fakeCoverage");
        catalog.add((StoreInfo)coverageStoreInfo);
        catalog.add((ResourceInfo)coverageInfo);
        catalog.add((LayerInfo)layerInfo2);
        this.params.put("LAYERS", "topp:states,topp:fakeCoverage");
        HashMap<String, Object> kvp = new HashMap<String, Object>(this.params);
        kvp.put("LAYERS", Arrays.asList(new MapLayerInfo((LayerInfo)layerInfo), new MapLayerInfo((LayerInfo)layerInfo2)));
        DescribeLayerRequest describeRequest = this.getRequest(this.params, kvp);
        DescribeLayerKvpRequestReaderTest.assertNotNull((Object)describeRequest);
        DescribeLayerKvpRequestReaderTest.assertNotNull((Object)describeRequest.getLayers());
        DescribeLayerKvpRequestReaderTest.assertEquals((int)2, (int)describeRequest.getLayers().size());
    }
}

