/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import com.mockrunner.mock.web.MockHttpServletRequest;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.legendgraphic.GetLegendGraphicKvpReader;
import org.geotools.styling.Style;

public class GetLegendGraphicKvpReaderTest
extends WMSTestSupport {
    GetLegendGraphicKvpReader requestReader;
    Map<String, String> requiredParameters;
    Map<String, String> optionalParameters;
    Map<String, String> allParameters;
    MockHttpServletRequest httpRequest;
    WMS wms;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetLegendGraphicKvpReaderTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.requiredParameters = new HashMap<String, String>();
        this.requiredParameters.put("VERSION", "1.0.0");
        this.requiredParameters.put("REQUEST", "GetLegendGraphic");
        this.requiredParameters.put("LAYER", "cite:Ponds");
        this.requiredParameters.put("FORMAT", "image/png");
        this.optionalParameters = new HashMap<String, String>();
        this.optionalParameters.put("STYLE", "Ponds");
        this.optionalParameters.put("FEATURETYPE", "fake_not_used");
        this.optionalParameters.put("SCALE", "1000");
        this.optionalParameters.put("WIDTH", "120");
        this.optionalParameters.put("HEIGHT", "90");
        this.allParameters = new HashMap<String, String>(this.requiredParameters);
        this.allParameters.putAll(this.optionalParameters);
        this.wms = this.getWMS();
        this.requestReader = new GetLegendGraphicKvpReader(this.wms);
        this.httpRequest = this.createRequest("wms", this.allParameters);
    }

    public void testRemoteSLDMultipleStyles() throws Exception {
        URL remoteSldUrl = ((Object)((Object)this)).getClass().getResource("MultipleStyles.sld");
        this.allParameters.put("SLD", remoteSldUrl.toExternalForm());
        this.allParameters.put("LAYER", "cite:Ponds");
        this.allParameters.put("STYLE", "Ponds");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Style selectedStyle = request.getStyle();
        GetLegendGraphicKvpReaderTest.assertNotNull((Object)selectedStyle);
        GetLegendGraphicKvpReaderTest.assertEquals((String)"Ponds", (String)selectedStyle.getName());
        this.allParameters.put("LAYER", "cite:Lakes");
        this.allParameters.put("STYLE", "Lakes");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        selectedStyle = request.getStyle();
        GetLegendGraphicKvpReaderTest.assertNotNull((Object)selectedStyle);
        GetLegendGraphicKvpReaderTest.assertEquals((String)"Lakes", (String)selectedStyle.getName());
    }

    public void testMissingLayerParameter() throws Exception {
        this.requiredParameters.remove("LAYER");
        try {
            this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
            GetLegendGraphicKvpReaderTest.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            GetLegendGraphicKvpReaderTest.assertEquals((String)"LayerNotDefined", (String)e.getCode());
        }
    }

    public void testMissingFormatParameter() throws Exception {
        this.requiredParameters.remove("FORMAT");
        try {
            this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
            GetLegendGraphicKvpReaderTest.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            GetLegendGraphicKvpReaderTest.assertEquals((String)"MissingFormat", (String)e.getCode());
        }
    }

    public void testStrictParameter() throws Exception {
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        GetLegendGraphicKvpReaderTest.assertTrue((boolean)request.isStrict());
        this.allParameters.put("STRICT", "false");
        this.allParameters.remove("LAYER");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        GetLegendGraphicKvpReaderTest.assertFalse((boolean)request.isStrict());
    }
}

