/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.svg;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.svg.SVGStreamingMapOutputFormat;
import org.geoserver.wms.svg.StreamingSVGMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SVGMapProducerTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new SVGMapProducerTest());
    }

    public void testHeterogeneousGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(10.0, 10.0));
        LineString line = gf.createLineString(new Coordinate[]{new Coordinate(50.0, 50.0), new Coordinate(100.0, 100.0)});
        Polygon polygon = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 200.0), new Coordinate(200.0, 200.0), new Coordinate(200.0, 0.0), new Coordinate(0.0, 0.0)}), null);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("test");
        ftb.add("geom", Geometry.class);
        SimpleFeatureType type = ftb.buildFeatureType();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{line}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{polygon}, null);
        MemoryDataStore ds = new MemoryDataStore();
        ds.createSchema(type);
        ds.addFeatures(new SimpleFeature[]{f1, f2, f3});
        SimpleFeatureSource fs = ds.getFeatureSource("test");
        WMSMapContext map = new WMSMapContext();
        map.setAreaOfInterest(new ReferencedEnvelope(-250.0, 250.0, -250.0, 250.0, null));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        Style basicStyle = this.getCatalog().getStyleByName("Default").getStyle();
        map.addLayer((FeatureSource)fs, basicStyle);
        SVGStreamingMapOutputFormat producer = new SVGStreamingMapOutputFormat();
        StreamingSVGMap encodeSVG = producer.produceMap(map);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        encodeSVG.encode((OutputStream)out);
        String expectedDoc = "<?xml version=\"1.0\" standalone=\"no\"?><svg xmlns=\"http://www.w3.org/2000/svg\"     xmlns:xlink=\"http://www.w3.org/1999/xlink\"     stroke=\"green\"      fill=\"none\"      stroke-width=\"0.1%\"     stroke-linecap=\"round\"     stroke-linejoin=\"round\"     width=\"300\"      height=\"300\"      viewBox=\"-250.0 -250.0 500.0 500.0\"      preserveAspectRatio=\"xMidYMid meet\">   <g id=\"test\" class=\"Default\">     <use x=\"10\" y=\"-10\" xlink:href=\"#point\"/>     <path d=\"M50 -50l50 -50 \"/>     <path d=\"M0 0l0 -200 200 0 0 200 -200 0 Z\"/>   </g> </svg> ";
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document expected = builder.parse(new InputSource(new StringReader(expectedDoc)));
        Document result = builder.parse(new ByteArrayInputStream(out.toByteArray()));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLAssert.assertXMLEqual((Document)expected, (Document)result);
    }
}

