/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.HashMap;
import java.util.Map;
import org.geotools.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WMSErrorCode {
    INVALID_CRS("InvalidSRS", "1.1.1", "InvalidSRS", "1.3.0", "InvalidCRS"),
    LAYER_NOT_QUERYABLE("OperationNotSupported", "1.1.1", "OperationNotSupported", "1.3.0", "LayerNotQueryable");

    String defaultCode;
    Map<Version, String> codes;

    private WMSErrorCode(String defaultCode, String ... mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of version/code mappings");
        }
        this.codes = new HashMap<Version, String>();
        int i = 0;
        while (i < mappings.length - 1) {
            this.codes.put(new Version(mappings[i]), mappings[i + 1]);
            i += 2;
        }
        this.defaultCode = defaultCode;
    }

    public String get(String version) {
        if (version != null) {
            return this.get(new Version(version));
        }
        return this.get(new Version("1.1.1"));
    }

    public String get(Version version) {
        String code = this.codes.get(version);
        return code != null ? code : this.defaultCode;
    }
}

