/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.xml.GML2OutputFormat;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML2FeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private static final String FORMAT = "application/vnd.ogc.gml";
    private WMS wms;

    public GML2FeatureInfoOutputFormat(WMS wms) {
        super(FORMAT);
        this.wms = wms;
    }

    public void write(FeatureCollectionType results, GetFeatureInfoRequest fInfoReq, OutputStream out) throws ServiceException, IOException {
        FeatureCollectionType features = WfsFactory.eINSTANCE.createFeatureCollectionType();
        GetFeatureType gfreq = WfsFactory.eINSTANCE.createGetFeatureType();
        gfreq.setBaseUrl(fInfoReq.getBaseUrl());
        for (SimpleFeatureCollection fc : results.getFeature()) {
            features.getFeature().add((Object)fc);
            QueryType qt = WfsFactory.eINSTANCE.createQueryType();
            String crs = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem());
            if (crs != null) {
                String srsName = "EPSG:" + crs;
                try {
                    qt.setSrsName(new URI(srsName));
                }
                catch (URISyntaxException e) {
                    throw new ServiceException("Unable to determite coordinate system for featureType " + ((SimpleFeatureType)fc.getSchema()).getTypeName() + ".  Schema told us '" + srsName + "'", (Throwable)e);
                }
            }
            gfreq.getQuery().add((Object)qt);
        }
        Service serviceDesc = new Service("wms", null, null, Collections.EMPTY_LIST);
        Operation opDescriptor = new Operation("", serviceDesc, null, new Object[]{gfreq});
        GeoServer gs = this.wms.getGeoServer();
        GML2OutputFormat format = new GML2OutputFormat(gs);
        format.write((Object)features, out, opDescriptor);
    }
}

