/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class TextFeatureInfoOutputFormat
extends GetFeatureInfoOutputFormat {
    private WMS wms;

    public TextFeatureInfoOutputFormat(WMS wms) {
        super("text/plain");
        this.wms = wms;
    }

    public void write(FeatureCollectionType results, GetFeatureInfoRequest request, OutputStream out) throws ServiceException, IOException {
        int featuresPrinted;
        PrintWriter writer;
        block14: {
            Charset charSet = this.wms.getCharSet();
            OutputStreamWriter osw = new OutputStreamWriter(out, charSet);
            writer = new PrintWriter(osw);
            featuresPrinted = 0;
            int maxfeatures = request.getFeatureCount();
            SimpleFeatureIterator reader = null;
            try {
                try {
                    EList collections = results.getFeature();
                    int size = collections.size();
                    int i = 0;
                    while (i < size) {
                        SimpleFeatureCollection fr = (SimpleFeatureCollection)collections.get(i);
                        reader = fr.features();
                        if (reader.hasNext() && featuresPrinted < maxfeatures) {
                            writer.println("Results for FeatureType '" + ((SimpleFeatureType)fr.getSchema()).getTypeName() + "':");
                        }
                        while (reader.hasNext()) {
                            SimpleFeature f = (SimpleFeature)reader.next();
                            SimpleFeatureType schema = f.getFeatureType();
                            List types = schema.getAttributeDescriptors();
                            if (featuresPrinted >= maxfeatures) continue;
                            writer.println("--------------------------------------------");
                            for (AttributeDescriptor descriptor : types) {
                                Name name = descriptor.getName();
                                if (Geometry.class.isAssignableFrom(descriptor.getType().getBinding())) {
                                    Geometry g = (Geometry)f.getAttribute(name);
                                    writer.println(name + " = [GEOMETRY (" + g.getGeometryType() + ") with " + g.getNumPoints() + " points]");
                                    continue;
                                }
                                writer.println(name + " = " + f.getAttribute(name));
                            }
                            writer.println("--------------------------------------------");
                            ++featuresPrinted;
                        }
                        ++i;
                    }
                }
                catch (Exception ife) {
                    LOGGER.log(Level.WARNING, "Error generating getFeaturInfo, HTML format", ife);
                    writer.println("Unable to generate information " + ife);
                    if (reader != null) {
                        reader.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            if (reader != null) {
                reader.close();
            }
        }
        if (featuresPrinted == 0) {
            writer.println("no features were found");
        }
        writer.flush();
    }
}

