/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import org.geoserver.wms.legendgraphic.ColorMapEntryLegendBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geoserver.wms.legendgraphic.SimpleColorManager;
import org.geoserver.wms.legendgraphic.TextManager;
import org.geotools.styling.ColorMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassesEntryLegendBuilder
extends ColorMapEntryLegendBuilder {
    public ClassesEntryLegendBuilder(List<ColorMapEntry> mapEntries, LegendUtils.HAlign hAlign, LegendUtils.VAlign vAling, Color bkgColor, double bkgOpacity, String text, Dimension requestedDimension, Font labelFont, Color labelFontColor, boolean fontAntiAliasing, Color borderColor) {
        ColorMapEntry previousCME = mapEntries.get(0);
        ColorMapEntry currentCME = mapEntries.get(1);
        boolean leftEdge = previousCME == null;
        Color color = LegendUtils.color(currentCME);
        double opacity = LegendUtils.getOpacity(currentCME);
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * opacity));
        super.add(new SimpleColorManager(color, opacity, requestedDimension, borderColor));
        String label = currentCME.getLabel();
        double quantity1 = leftEdge ? LegendUtils.getQuantity(currentCME) : LegendUtils.getQuantity(previousCME);
        double quantity2 = LegendUtils.getQuantity(currentCME);
        String symbol1 = null;
        String symbol2 = null;
        if (leftEdge) {
            symbol1 = " < ";
        } else {
            symbol1 = " <= ";
            symbol2 = " < ";
        }
        String rule = leftEdge ? String.valueOf(Double.toString(quantity1)) + " " + symbol1 + " x" : String.valueOf(Double.toString(quantity1)) + " " + symbol1 + " x " + symbol2 + " " + Double.toString(quantity2);
        super.add(new TextManager(rule, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
        if (label != null) {
            this.hasLabel = true;
            super.add(new TextManager(label, vAling, hAlign, bkgColor, requestedDimension, labelFont, labelFontColor, leftEdge, borderColor));
        } else {
            super.add(null);
        }
    }
}

