/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageOutputStream;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;

public class GeoTIFFMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(GeoTIFFMapResponse.class);
    private static final String IMAGE_GEOTIFF = "image/geotiff";
    private static final String IMAGE_GEOTIFF8 = "image/geotiff8";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/geotiff", "image/geotiff8"};
    private static final GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);

    public GeoTIFFMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContext mapContext) throws ServiceException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image ...");
        }
        GetMapRequest request = mapContext.getRequest();
        String format = request.getFormat();
        InverseColorMapOp paletteInverter = mapContext.getPaletteInverter();
        if (IMAGE_GEOTIFF8.equalsIgnoreCase(format) || paletteInverter != null) {
            image = this.forceIndexed8Bitmask(image, paletteInverter);
        }
        GridCoverage2D gc = factory.create((CharSequence)"geotiff", image, (Envelope)new GeneralEnvelope((Envelope)mapContext.getAreaOfInterest()));
        ImageOutputStream imageOutStream = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)outStream);
        if (imageOutStream == null) {
            throw new ServiceException("Unable to create ImageOutputStream.");
        }
        GeoTiffWriter writer = null;
        try {
            writer = new GeoTiffWriter((Object)imageOutStream);
            writer.write((GridCoverage)gc, null);
        }
        finally {
            block18: {
                block17: {
                    try {
                        imageOutStream.close();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block17;
                        LOGGER.log(Level.FINEST, "Unable to properly close output stream", e);
                    }
                }
                try {
                    if (writer != null) {
                        writer.dispose();
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block18;
                    LOGGER.log(Level.FINEST, "Unable to properly dispose writer", e);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }
}

