/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.ImageWorker;
import org.geotools.image.palette.InverseColorMapOp;
import org.geotools.util.logging.Logging;

public class PNGMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(PNGMapResponse.class);
    private static final String MIME_TYPE = "image/png";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/png", "image/png8"};

    public PNGMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContext mapContext) throws ServiceException, IOException {
        String format;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ...");
        }
        if ("image/png8".equalsIgnoreCase(format = mapContext.getRequest().getFormat()) || mapContext.getPaletteInverter() != null) {
            InverseColorMapOp paletteInverter = mapContext.getPaletteInverter();
            image = this.forceIndexed8Bitmask(image, paletteInverter);
        }
        Boolean PNGNativeAcc = this.wms.getPNGNativeAcceleration();
        float quality = (float)(100 - this.wms.getPngCompression()) / 100.0f;
        SampleModel sm = image.getSampleModel();
        int numBits = sm.getSampleSize(0);
        boolean nativeAcceleration = PNGNativeAcc != false && (numBits <= 1 || numBits >= 8);
        new ImageWorker(image).writePNG((Object)outStream, "FILTERED", quality, nativeAcceleration, image.getColorModel() instanceof IndexColorModel);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ... done!");
        }
    }
}

