/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockServletContext;
import com.vividsolutions.jts.geom.Point;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.kml.KMLLegendTransformer;
import org.geoserver.kml.KMLReflectorTest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollections;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.xml.transform.TransformerBase;
import org.w3c.dom.Document;

public class KMLLegendTransformerTest
extends TestCase {
    private WMSMockData mockData;
    private WMSMapContext mapContext;
    private MapLayer mapLayer;
    private MockHttpServletRequest httpreq;

    protected void setUp() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        this.httpreq = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        this.httpreq.setSession((HttpSession)session);
        MockServletContext context = new MockServletContext();
        session.setupServletContext((ServletContext)context);
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("TestPoints", Point.class);
        this.mapContext = new WMSMapContext();
        GetMapRequest request = this.mockData.createRequest();
        request.setLayers(Collections.singletonList(layer));
        SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getFeature().getFeatureSource(null, null);
        this.mapLayer = new DefaultMapLayer((FeatureSource)featureSource, this.mockData.getDefaultStyle().getStyle());
        this.httpreq.setScheme("http");
        this.httpreq.setServerName("geoserver.org");
        this.httpreq.setServerPort(8181);
        this.httpreq.setContextPath("/geoserver");
        this.mapContext.setRequest(request);
    }

    protected void tearDown() throws Exception {
    }

    public void testKMLLegendTransformer() throws Exception {
        SimpleFeatureCollection features = FeatureCollections.newCollection();
        XpathEngine xpath = XMLUnit.newXpathEngine();
        KMLLegendTransformer transformer = new KMLLegendTransformer(this.mapContext);
        transformer.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.mapLayer, (TransformerBase)transformer);
        XMLAssert.assertXpathEvaluatesTo((String)"Legend", (String)"//kml/ScreenOverlay/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/ScreenOverlay/overlayXY/@x", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//kml/ScreenOverlay/overlayXY/@y", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml/ScreenOverlay/overlayXY/@xunits", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"pixels", (String)"//kml/ScreenOverlay/overlayXY/@yunits", (Document)dom);
        Map<String, String> expectedKVP = KMLReflectorTest.toKvp("http://geoserver.org:8181/geoserver/wms?service=wms&width=20&height=20&style=Default+Style&request=GetLegendGraphic&layer=&format=image%2Fpng&version=1.1.1");
        Map<String, String> resultantKVP = KMLReflectorTest.toKvp(xpath.evaluate("//kml/ScreenOverlay/Icon/href", dom));
        KMLReflectorTest.assertMapsEqual(expectedKVP, resultantKVP);
    }
}

