/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.WMSMockData;
import org.geoserver.wms.WebMap;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class GetMapTest
extends TestCase {
    private WMSMockData mockData;
    private GetMapRequest request;
    private GetMap getMapOp;

    protected void setUp() throws Exception {
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        this.request = this.mockData.createRequest();
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testType", Point.class);
        this.request.setLayers(Arrays.asList(layer));
        this.getMapOp = new GetMap(this.mockData.getWMS());
    }

    protected void tearDown() throws Exception {
    }

    public void testExecuteNoExtent() {
        this.request.setBbox(null);
        this.assertInvalidMandatoryParam("MissingBBox");
    }

    public void testExecuteEmptyExtent() {
        this.request.setBbox(new Envelope());
        this.assertInvalidMandatoryParam("InvalidBBox");
    }

    public void testSingleVectorLayer() throws IOException {
        this.request.setFormat("image/dummy");
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testSingleVectorLayer", Point.class);
        this.request.setLayers(Arrays.asList(layer));
        final WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer();
        WMS wms = new WMS(this.mockData.getGeoServer()){

            public GetMapOutputFormat getMapOutputFormat(String mimeType) {
                if ("image/dummy".equals(mimeType)) {
                    return producer;
                }
                return null;
            }
        };
        this.getMapOp = new GetMap(wms);
        this.getMapOp.run(this.request);
        GetMapTest.assertTrue((boolean)producer.produceMapCalled);
    }

    public void testExecuteNoLayers() throws Exception {
        this.request.setLayers(null);
        this.assertInvalidMandatoryParam("LayerNotDefined");
    }

    public void testExecuteNoWidth() {
        this.request.setWidth(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setWidth(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    public void testExecuteNoHeight() {
        this.request.setHeight(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setHeight(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    public void testExecuteInvalidFormat() {
        this.request.setFormat("non-existent-output-format");
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    public void testExecuteNoFormat() {
        this.request.setFormat(null);
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    public void testExecuteNoStyles() {
        this.request.setStyles(null);
        this.assertInvalidMandatoryParam("StyleNotDefined");
    }

    public void testEnviroment() {
        final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        this.request.setEnv(Collections.singletonMap("myParam", 23));
        final WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer(){

            public WebMap produceMap(WMSMapContext ctx) throws ServiceException, IOException {
                GetMapTest.assertEquals((Object)23, (Object)ff.function("env", new Expression[]{ff.literal((Object)"myParam")}).evaluate(null));
                GetMapTest.assertEquals((Object)10, (Object)ff.function("env", new Expression[]{ff.literal((Object)"otherParam"), ff.literal(10)}).evaluate(null));
                this.produceMapCalled = true;
                return null;
            }
        };
        WMS wms = new WMS(this.mockData.getGeoServer()){

            public GetMapOutputFormat getMapOutputFormat(String mimeType) {
                if ("image/dummy".equals(mimeType)) {
                    return producer;
                }
                return null;
            }
        };
        this.getMapOp = new GetMap(wms);
        WebMap map = this.getMapOp.run(this.request);
        GetMapTest.assertTrue((boolean)producer.produceMapCalled);
        GetMapTest.assertNull((Object)ff.function("env", new Expression[]{ff.literal((Object)"myParam")}).evaluate(null));
        GetMapTest.assertEquals((Object)10, (Object)ff.function("env", new Expression[]{ff.literal((Object)"otherParam"), ff.literal(10)}).evaluate(null));
    }

    private void assertInvalidMandatoryParam(String expectedExceptionCode) {
        try {
            this.getMapOp.run(this.request);
            GetMapTest.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            GetMapTest.assertEquals((String)expectedExceptionCode, (String)e.getCode());
        }
    }
}

