/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.image.test.ImageAssert;

public class GetMapIntegrationTest
extends WMSTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWcs10Coverages();
        dataDirectory.addStyle("indexed", GetMapIntegrationTest.class.getResource("indexed.sld"));
        dataDirectory.addCoverage(new QName(MockData.SF_URI, "indexed", MockData.SF_PREFIX), GetMapIntegrationTest.class.getResource("indexed.tif"), "tif", "indexed");
        dataDirectory.addCoverage(new QName(MockData.SF_URI, "paletted", MockData.SF_PREFIX), GetMapIntegrationTest.class.getResource("paletted.tif"), "tif", "raster");
        dataDirectory.addCoverage(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("../raster-filter-test.zip"), null, "raster");
        dataDirectory.addCoverage(new QName(MockData.SF_URI, "fourbits", MockData.SF_PREFIX), MockData.class.getResource("fourbits.zip"), null, "raster");
    }

    public void testIndexed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?LAYERS=sf:indexed&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=100,78,104,80&WIDTH=300&HEIGHT=150");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/indexed-expected.png"), (RenderedImage)image, (int)0);
    }

    public void testIndexedBlackBG() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:indexed&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=100,78,104,80&WIDTH=300&HEIGHT=150&transparent=false");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/indexed-bg-expected.png"), (RenderedImage)image, (int)0);
    }

    public void testRasterFilterRed() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'red%25'");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        GetMapIntegrationTest.assertEquals((int)255, (int)pixel[0]);
        GetMapIntegrationTest.assertEquals((int)0, (int)pixel[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)pixel[2]);
    }

    public void testRasterFilterGreen() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'green%25'");
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        int[] pixel = new int[3];
        image.getData().getPixel(0, 0, pixel);
        GetMapIntegrationTest.assertEquals((int)0, (int)pixel[0]);
        GetMapIntegrationTest.assertEquals((int)255, (int)pixel[1]);
        GetMapIntegrationTest.assertEquals((int)0, (int)pixel[2]);
    }

    public void testIndexedTransparency() throws Exception {
        String request = "wms?LAYERS=sf:paletted&STYLES=&FORMAT=image%2Fpng&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A3174&BBOX=-3256153.625,826440.25,-2756153.625,1326440.25&WIDTH=256&HEIGHT=256&transparent=true";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        GetMapIntegrationTest.assertTrue((boolean)image.getColorModel().hasAlpha());
        int[] rgba = new int[4];
        image.getData().getPixel(0, 0, rgba);
        GetMapIntegrationTest.assertEquals((int)0, (int)rgba[3]);
        image.getData().getPixel(255, 255, rgba);
        GetMapIntegrationTest.assertEquals((int)255, (int)rgba[3]);
    }

    public void testFourBits() throws Exception {
        String request = "wms?LAYERS=sf:fourbits&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG%3A4269&BBOX=-118.58930224611,45.862378906251,-118.33030957033,45.974688476563&WIDTH=761&HEIGHT=330";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        GetMapIntegrationTest.assertEquals((String)"image/png", (String)response.getContentType());
    }
}

