/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import junit.framework.Test;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.kvp.PaletteManager;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.Style;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;

public class GetMapKvpRequestReaderTest
extends KvpRequestReaderTestSupport {
    GetMapKvpRequestReader reader;
    Dispatcher dispatcher;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetMapKvpRequestReaderTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        CatalogFactory cf = this.getCatalog().getFactory();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo gi = cf.createLayerGroup();
        gi.setName("testGroup");
        gi.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi.getStyles().add(this.getCatalog().getStyleByName("polygon"));
        cb.calculateLayerGroupBounds(gi);
        this.getCatalog().add(gi);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dispatcher = (Dispatcher)applicationContext.getBean("dispatcher");
        WMS wms = new WMS(this.getGeoServer());
        this.reader = new GetMapKvpRequestReader(wms);
    }

    public void testCreateRequest() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        GetMapKvpRequestReaderTest.assertNotNull((Object)request);
    }

    public void testReadMandatory() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        String layer = MockData.BASIC_POLYGONS.getLocalPart();
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapKvpRequestReaderTest.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(layer));
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getStyles().size());
        Style expected = this.getCatalog().getStyleByName(layer).getStyle();
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)expected, (Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"image/jpeg", (String)request.getFormat());
        GetMapKvpRequestReaderTest.assertEquals((int)600, (int)request.getHeight());
        GetMapKvpRequestReaderTest.assertEquals((int)800, (int)request.getWidth());
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getBbox());
        GetMapKvpRequestReaderTest.assertEquals((double)-10.0, (double)request.getBbox().getMinX(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((double)-10.0, (double)request.getBbox().getMinY(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((double)10.0, (double)request.getBbox().getMaxX(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((double)10.0, (double)request.getBbox().getMaxY(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((String)"epsg:3003", (String)request.getSRS());
    }

    public void testReadOptional() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("bgcolor", "000000");
        kvp.put("transparent", "true");
        kvp.put("tiled", "true");
        kvp.put("tilesorigin", "1.2,3.4");
        kvp.put("buffer", "1");
        kvp.put("palette", "SAFE");
        kvp.put("time", "2006-02-27T22:08:12Z");
        kvp.put("elevation", "4");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertEquals((Object)Color.BLACK, (Object)request.getBgColor());
        GetMapKvpRequestReaderTest.assertTrue((boolean)request.isTransparent());
        GetMapKvpRequestReaderTest.assertTrue((boolean)request.isTiled());
        GetMapKvpRequestReaderTest.assertEquals((Object)new Point2D.Double(1.2, 3.4), (Object)request.getTilesOrigin());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getBuffer());
        GetMapKvpRequestReaderTest.assertEquals((Object)PaletteManager.safePalette, (Object)request.getPalette().getIcm());
        GetMapKvpRequestReaderTest.assertEquals((Object)4.0, (Object)request.getElevation());
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.set(2006, 1, 27, 22, 8, 12);
        List times = request.getTime();
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getTime().size());
        GetMapKvpRequestReaderTest.assertEquals((String)cal.getTime().toString(), (String)((Date)times.get(0)).toString());
    }

    public void testDefaultStyle() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "," + MockData.BUILDINGS.getPrefix() + ":" + MockData.BUILDINGS.getLocalPart());
        raw.put("styles", ",");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)request.getStyles().size());
        LayerInfo basicPolygons = this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart());
        LayerInfo buildings = this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart());
        GetMapKvpRequestReaderTest.assertEquals((Object)basicPolygons.getDefaultStyle().getStyle(), request.getStyles().get(0));
        GetMapKvpRequestReaderTest.assertEquals((Object)buildings.getDefaultStyle().getStyle(), request.getStyles().get(1));
    }

    public void testFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("filter", "<Filter><FeatureId id=\"foo\"/></Filter>");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getFilter());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getFilter().size());
        Id fid = (Id)request.getFilter().get(0);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)fid.getIDs().size());
        GetMapKvpRequestReaderTest.assertEquals((Object)"foo", fid.getIDs().iterator().next());
    }

    public void testCQLFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("cql_filter", "foo = bar");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getCQLFilter());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getCQLFilter().size());
        PropertyIsEqualTo filter = (PropertyIsEqualTo)request.getCQLFilter().get(0);
    }

    public void testFeatureId() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("featureid", "foo");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getFeatureId());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getFeatureId().size());
        GetMapKvpRequestReaderTest.assertEquals((Object)"foo", request.getFeatureId().get(0));
    }

    public void testSldNoDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = this.reader.createRequest();
        this.reader.setLaxStyleMatchAllowed(false);
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"BasicPolygons", (String)style.getName());
    }

    public void testSldDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
    }

    public void testSldNamed() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "TheLibraryModeStyle");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
    }

    public void testSldFailLookup() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void testSldFeatureTypeConstraints() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsFeatureTypeConstaint.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        MapLayerInfo layer = (MapLayerInfo)request.getLayers().get(0);
        GetMapKvpRequestReaderTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)layer.getName());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)layer.getLayerFeatureConstraints().length);
        GetMapKvpRequestReaderTest.assertEquals((Object)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"xyz")), (Object)layer.getLayerFeatureConstraints()[0].getFilter());
    }

    public void testSldLibraryFeatureTypeConstraints() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsFeatureTypeConstaint.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", String.valueOf(MockData.BASIC_POLYGONS.getPrefix()) + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "TheLibraryModeStyle");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        MapLayerInfo layer = (MapLayerInfo)request.getLayers().get(0);
        GetMapKvpRequestReaderTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)layer.getName());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)layer.getLayerFeatureConstraints().length);
        GetMapKvpRequestReaderTest.assertEquals((Object)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"xyz")), (Object)layer.getLayerFeatureConstraints()[0].getFilter());
    }

    public void testWmtVer() throws Exception {
        this.dispatcher.setCiteCompliant(true);
        String request = "wms?SERVICE=WMS&&WiDtH=200&FoRmAt=image/png&LaYeRs=cite:Lakes&StYlEs=&BbOx=0,-0.0020,0.0040,0&ReQuEsT=GetMap&HeIgHt=100&SrS=EPSG:4326&WmTvEr=1.1.1";
        GetMapKvpRequestReaderTest.assertEquals((String)"image/png", (String)this.getAsServletResponse(request).getContentType());
    }

    public void testRemoteWFS() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://demo.opengeo.org/geoserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        GetMapKvpRequestReaderTest.assertEquals((String)"WFS", (String)request.getRemoteOwsType());
        GetMapKvpRequestReaderTest.assertEquals((Object)new URL("http://demo.opengeo.org/geoserver/wfs?"), (Object)request.getRemoteOwsURL());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapKvpRequestReaderTest.assertEquals((int)LayerInfo.Type.REMOTE.getCode(), (int)((MapLayerInfo)request.getLayers().get(0)).getType());
        GetMapKvpRequestReaderTest.assertEquals((String)"topp:states", (String)((MapLayerInfo)request.getLayers().get(0)).getName());
    }

    public void testRemoteWFSNoStyle() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://demo.opengeo.org/geoserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        try {
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            GetMapKvpRequestReaderTest.fail((String)"This should have thrown an exception because of the missing style");
        }
        catch (ServiceException e) {
            GetMapKvpRequestReaderTest.assertEquals((String)"NoDefaultStyle", (String)e.getCode());
        }
    }

    public void testRemoteWFSInvalidURL() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://phantom.openplans.org:8080/crapserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        try {
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            GetMapKvpRequestReaderTest.fail((String)"This should have thrown an exception because of the non existent layer");
        }
        catch (ServiceException e) {
            e.printStackTrace();
            GetMapKvpRequestReaderTest.assertEquals((String)"RemoteOWSFailure", (String)e.getCode());
        }
    }

    public void testGroupInSLD() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("srs", "epsg:4326");
        kvp.put("bbox", "124.38035938267053,-58.45445933799711,169.29632161732948,-24.767487662002893");
        kvp.put("width", "640");
        kvp.put("height", "480");
        kvp.put("format", "image/png");
        URL url = GetMapKvpRequestReader.class.getResource("BaseMapGroup.sld");
        kvp.put("sld", URLDecoder.decode(url.toString(), "UTF-8"));
        kvp.put("version", "1.1.1");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getStyles().size());
        GetMapKvpRequestReaderTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)((MapLayerInfo)request.getLayers().get(0)).getName());
        Style expectedStyle = this.getCatalog().getStyleByName("polygon").getStyle();
        GetMapKvpRequestReaderTest.assertEquals((Object)expectedStyle, request.getStyles().get(0));
    }

    public void testViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
    }

    public void testMultipleViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", String.valueOf(this.getLayerId(MockData.BASIC_POLYGONS)) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD,where:WHERE PERSONS > 10;str:FOO");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
        viewParams = (Map)viewParamsList.get(1);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 10", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"FOO", viewParams.get("str"));
    }

    public void testFanOutViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", String.valueOf(this.getLayerId(MockData.BASIC_POLYGONS)) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
        viewParams = (Map)viewParamsList.get(1);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
    }
}

