/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.util.logging.Level;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;

public class GetFeatureInfoTest
extends WMSTestSupport {
    public static String WCS_PREFIX = "wcs";
    public static String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    public static QName TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
    public static QName SQUARES = new QName(MockData.CITE_URI, "squares", MockData.CITE_PREFIX);

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetFeatureInfoTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        Logging.getLogger((String)"org.geoserver.ows").setLevel(Level.OFF);
        WMSInfo wmsInfo = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wmsInfo.setMaxBuffer(50);
        this.getGeoServer().save((ServiceInfo)wmsInfo);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("thickStroke", GetFeatureInfoTest.class.getResource("thickStroke.sld"));
        dataDirectory.addStyle("raster", GetFeatureInfoTest.class.getResource("raster.sld"));
        dataDirectory.addStyle("rasterScales", GetFeatureInfoTest.class.getResource("rasterScales.sld"));
        dataDirectory.addCoverage(TASMANIA_BM, GetFeatureInfoTest.class.getResource("tazbm.tiff"), "tiff", "raster");
        dataDirectory.addStyle("squares", GetFeatureInfoTest.class.getResource("squares.sld"));
        dataDirectory.addPropertiesType(SQUARES, GetFeatureInfoTest.class.getResource("squares.properties"), null);
        dataDirectory.addCoverage(new QName(MockData.SF_URI, "mosaic", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("../raster-filter-test.zip"), null, "raster");
    }

    public void testSimple() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        GetFeatureInfoTest.assertNotNull((Object)result);
        GetFeatureInfoTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    public void testSimpleHtml() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'Forests.')])", (Document)dom);
    }

    public void testBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.1.1&bbox=-4.5,-2.,4.5,7&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300";
        Document dom = this.getAsDOM(String.valueOf(base) + "&x=85&y=230");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(String.valueOf(base) + "&x=85&y=230&buffer=40");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
        dom = this.getAsDOM(String.valueOf(base) + "&x=85&y=230&buffer=300");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    public void testAutoBuffer() throws Exception {
        String layer = this.getLayerId(MockData.BASIC_POLYGONS);
        String base = "wms?version=1.1.1&bbox=-4.5,-2.,4.5,7&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=300&height=300&x=114&y=229";
        Document dom = this.getAsDOM(String.valueOf(base) + "&styles=");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        dom = this.getAsDOM(String.valueOf(base) + "&styles=thickStroke");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'BasicPolygons.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'BasicPolygons.1107531493630'])", (Document)dom);
    }

    public void testBufferScales() throws Exception {
        String layer = this.getLayerId(SQUARES);
        String base = "wms?version=1.1.1&format=png&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&styles=squares&bbox=0,0,10000,10000&feature_count=10";
        int w = 357142;
        Document dom = this.getAsDOM(String.valueOf(base) + "&width=" + w + "&height=" + w + "&x=20&y=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr)", (Document)dom);
        w = 714285;
        dom = this.getAsDOM(String.valueOf(base) + "&width=" + w + "&height=" + w + "&x=20&y=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        w = 3571428;
        dom = this.getAsDOM(String.valueOf(base) + "&width=" + w + "&height=" + w + "&x=20&y=" + (w - 20));
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(/html/body/table/tr/td[starts-with(.,'squares.')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.1'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/td[. = 'squares.2'])", (Document)dom);
    }

    public void testTwoLayers() throws Exception {
        String layer = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info";
        String result = this.getAsString(request);
        GetFeatureInfoTest.assertNotNull((Object)result);
        GetFeatureInfoTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        GetFeatureInfoTest.assertTrue((result.indexOf("<style type=\"text/css\">") > 0 ? 1 : 0) != 0);
    }

    public void testTwoLayersFeatureCount() throws Exception {
        String layer = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.LAKES);
        String request = "wms?REQUEST=GetFeatureInfo&EXCEPTIONS=application%2Fvnd.ogc.se_xml&BBOX=-0.002356%2C-0.004819%2C0.005631%2C0.004781&SERVICE=WMS&VERSION=1.1.0&X=267&Y=325&INFO_FORMAT=application/vnd.ogc.gml&QUERY_LAYERS=" + layer + "&Layers=" + layer + " &Styles=&WIDTH=426&HEIGHT=512" + "&format=image%2Fpng&srs=EPSG%3A4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMember)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Forests)", (Document)dom);
        dom = this.getAsDOM(String.valueOf(request) + "&FEATURE_COUNT=2");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gml:featureMember)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Forests)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Lakes)", (Document)dom);
    }

    public void testUknownFormat() throws Exception {
        String layer = String.valueOf(MockData.FORESTS.getPrefix()) + ":" + MockData.FORESTS.getLocalPart();
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=unknown/format&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        Document doc = this.dom(this.get(request), true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ServiceExceptionReport/ServiceException)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidFormat", (String)"/ServiceExceptionReport/ServiceException/@code", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"info_format", (String)"/ServiceExceptionReport/ServiceException/@locator", (Document)doc);
    }

    public void testCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600" + "&info_format=text/html&query_layers=" + layer + "&x=300&y=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    public void testCoverageGML() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=&bbox=146.5,-44.5,148,-43&width=600&height=600" + "&info_format=application/vnd.ogc.gml&query_layers=" + layer + "&x=300&y=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(request);
        XMLAssert.assertXpathEvaluatesTo((String)"26.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:RED_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"70.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:GREEN_BAND", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"126.0", (String)"//wfs:FeatureCollection/gml:featureMember/wcs:BlueMarble/wcs:BLUE_BAND", (Document)dom);
    }

    public void testCoverageScales() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=rasterScales&bbox=146.5,-44.5,148,-43" + "&info_format=text/html&query_layers=" + layer + "&x=300&y=300&srs=EPSG:4326";
        Document dom = this.getAsDOM(String.valueOf(request) + "&width=300&height=300");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
        dom = this.getAsDOM(String.valueOf(request) + "&width=600&height=600");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'RED_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'GREEN_BAND'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html/body/table/tr/th[. = 'BLUE_BAND'])", (Document)dom);
    }

    public void testOutsideCoverage() throws Exception {
        String layer = this.getLayerId(TASMANIA_BM);
        String request = "wms?service=wms&request=GetFeatureInfo&version=1.1.1&layers=" + layer + "&styles=raster&bbox=0,-90,148,-43" + "&info_format=text/html&query_layers=" + layer + "&width=300&height=300&x=10&y=150&srs=EPSG:4326";
        Document dom = this.getAsDOM(String.valueOf(request));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/html)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/html/body/table/tr/th)", (Document)dom);
    }

    public void testUnkonwnQueryLayer() throws Exception {
        String layers1 = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.LAKES);
        String layers2 = String.valueOf(this.getLayerId(MockData.FORESTS)) + "," + this.getLayerId(MockData.BRIDGES);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/html&request=GetFeatureInfo&layers=" + layers1 + "&query_layers=" + layers2 + "&width=20&height=20&x=10&y=10&info";
        Document dom = this.getAsDOM(String.valueOf(request));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/ServiceExceptionReport)", (Document)dom);
    }

    public void testLayerQualified() throws Exception {
        String layer = "Forests";
        String q = "?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String request = "cite/Ponds/wms" + q;
        Document dom = this.getAsDOM(request);
        GetFeatureInfoTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
        request = "cite/Forests/wms" + q;
        String result = this.getAsString(request);
        GetFeatureInfoTest.assertNotNull((Object)result);
        GetFeatureInfoTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    public void testNonExactVersion() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.0.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        String result = this.getAsString(request);
        GetFeatureInfoTest.assertNotNull((Object)result);
        GetFeatureInfoTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        request = "wms?version=1.1.0&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&info_format=text/plain&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10";
        result = this.getAsString(request);
        GetFeatureInfoTest.assertNotNull((Object)result);
        GetFeatureInfoTest.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
    }

    public void testRasterFilterRed() throws Exception {
        String response = this.getAsString("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'red%25' + &query_layers=sf:mosaic&x=10&y=10");
        GetFeatureInfoTest.assertTrue((response.indexOf("RED_BAND = 255.0") > 0 ? 1 : 0) != 0);
        GetFeatureInfoTest.assertTrue((response.indexOf("GREEN_BAND = 0.0") > 0 ? 1 : 0) != 0);
        GetFeatureInfoTest.assertTrue((response.indexOf("BLUE_BAND = 0.0") > 0 ? 1 : 0) != 0);
    }

    public void testRasterFilterGreen() throws Exception {
        String response = this.getAsString("wms?bgcolor=0x000000&LAYERS=sf:mosaic&STYLES=&FORMAT=image/png&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&SRS=EPSG:4326&BBOX=0,0,1,1&WIDTH=150&HEIGHT=150&transparent=false&CQL_FILTER=location like 'green%25' + &query_layers=sf:mosaic&x=10&y=10");
        GetFeatureInfoTest.assertTrue((response.indexOf("RED_BAND = 0.0") > 0 ? 1 : 0) != 0);
        GetFeatureInfoTest.assertTrue((response.indexOf("GREEN_BAND = 255.0") > 0 ? 1 : 0) != 0);
        GetFeatureInfoTest.assertTrue((response.indexOf("BLUE_BAND = 0.0") > 0 ? 1 : 0) != 0);
    }
}

