/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.mockrunner.mock.web.MockHttpServletResponse;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.data.FeatureSource;
import org.geotools.map.FeatureSourceMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WMSTestSupport
extends GeoServerTestSupport {
    private static final String NATURE_GROUP = "nature";
    protected static final int SHOW_TIMEOUT = 2000;
    protected static final boolean INTERACTIVE = false;
    protected static final Color BG_COLOR = Color.white;

    protected WMS getWMS() {
        WMS wms = (WMS)applicationContext.getBean("wms");
        return wms;
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("wcs", "http://www.opengis.net/wcs/1.1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        this.getTestData().registerNamespaces(namespaces);
        this.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = catalog.getFactory().createLayerGroup();
        LayerInfo lakes = catalog.getLayerByName(this.getLayerId(MockData.LAKES));
        LayerInfo forests = catalog.getLayerByName(this.getLayerId(MockData.FORESTS));
        group.setName(NATURE_GROUP);
        group.getLayers().add(lakes);
        group.getLayers().add(forests);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.calculateLayerGroupBounds(group);
        catalog.add(group);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
    }

    protected void registerNamespaces(Map<String, String> namespaces) {
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("default", MockData.class.getResource("Default.sld"));
    }

    protected MapLayer createMapLayer(QName layerName) throws IOException {
        return this.createMapLayer(layerName, null);
    }

    protected MapLayer createMapLayer(QName layerName, String styleName) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo info = catalog.getFeatureTypeByName(layerName.getNamespaceURI(), layerName.getLocalPart());
        LayerInfo layerInfo = catalog.getLayerByName(layerName.getLocalPart());
        Style style = layerInfo.getDefaultStyle().getStyle();
        if (styleName != null) {
            style = catalog.getStyleByName(styleName).getStyle();
        }
        FeatureSource featureSource = info.getFeatureSource(null, null);
        FeatureSourceMapLayer layer = new FeatureSourceMapLayer(featureSource, style);
        layer.setTitle(layer.getTitle());
        return layer;
    }

    protected GetMapRequest createGetMapRequest(QName layerName) {
        return this.createGetMapRequest(new QName[]{layerName});
    }

    protected GetMapRequest createGetMapRequest(QName[] layerNames) {
        GetMapRequest request = new GetMapRequest();
        request.setBaseUrl("http://localhost:8080/geoserver");
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>(layerNames.length);
        ArrayList<Style> styles = new ArrayList<Style>();
        int i = 0;
        while (i < layerNames.length) {
            LayerInfo layerInfo = this.getCatalog().getLayerByName(layerNames[i].getLocalPart());
            try {
                styles.add(layerInfo.getDefaultStyle().getStyle());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            layers.add(new MapLayerInfo(layerInfo));
            ++i;
        }
        request.setLayers(layers);
        request.setStyles(styles);
        request.setBbox(new Envelope(-180.0, -90.0, 180.0, 90.0));
        request.setCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        request.setSRS("EPSG:4326");
        request.setRawKvp(new HashMap());
        return request;
    }

    protected void assertNotBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = this.countNonBlankPixels(testName, image, bgColor);
        WMSTestSupport.assertTrue((String)(String.valueOf(testName) + " image is comlpetely blank"), (pixelsDiffer > 0 ? 1 : 0) != 0);
    }

    protected int countNonBlankPixels(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = 0;
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                if (image.getRGB(x, y) != bgColor.getRGB()) {
                    ++pixelsDiffer;
                }
                ++x;
            }
            ++y;
        }
        LOGGER.fine(String.valueOf(testName) + ": pixel count=" + image.getWidth() * image.getHeight() + " non bg pixels: " + pixelsDiffer);
        return pixelsDiffer;
    }

    public static Document transform(Object req, TransformerBase tr) throws Exception {
        return WMSTestSupport.transform(req, tr, true);
    }

    public static Document transform(Object req, TransformerBase tr, boolean namespaceAware) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        tr.transform(req, (OutputStream)out);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaceAware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        class EmptyResolver
        implements EntityResolver {
            EmptyResolver() {
            }

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                InputSource source = new InputSource(reader);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
        }
        db.setEntityResolver(new EmptyResolver());
        Document doc = db.parse(new ByteArrayInputStream(out.toByteArray()));
        return doc;
    }

    protected void assertNotBlank(String testName, BufferedImage image) {
        this.assertNotBlank(testName, image, BG_COLOR);
        this.showImage(testName, image);
    }

    protected void showImage(String frameName, BufferedImage image) {
        this.showImage(frameName, 2000L, image);
    }

    protected void showImage(String frameName, long timeOut, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (System.getProperty("java.awt.headless") != null) {
            System.getProperty("java.awt.headless").equals("true");
        }
    }

    protected void checkImage(MockHttpServletResponse response) {
        this.checkImage(response, "image/png");
    }

    protected void checkImage(MockHttpServletResponse response, String mimeType) {
        WMSTestSupport.assertEquals((String)mimeType, (String)response.getContentType());
        try {
            BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
            WMSTestSupport.assertNotNull((Object)image);
            WMSTestSupport.assertEquals((int)image.getWidth(), (int)550);
            WMSTestSupport.assertEquals((int)image.getHeight(), (int)250);
        }
        catch (Throwable t) {
            t.printStackTrace();
            WMSTestSupport.fail((String)("Could not read image returned from GetMap:" + t.getLocalizedMessage()));
        }
    }

    protected BufferedImage getAsImage(String path, String mime) throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse(path);
        WMSTestSupport.assertEquals((String)mime, (String)resp.getContentType());
        ByteArrayInputStream is = this.getBinaryInputStream(resp);
        return ImageIO.read(is);
    }

    protected void assertPixel(BufferedImage image, int i, int j, Color color) {
        Color actual = this.getPixelColor(image, i, j);
        WMSTestSupport.assertEquals((Object)color, (Object)actual);
    }

    protected Color getPixelColor(BufferedImage image, int i, int j) {
        ColorModel cm = image.getColorModel();
        WritableRaster raster = image.getRaster();
        Object pixel = raster.getDataElements(i, j, null);
        Color actual = cm.hasAlpha() ? new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), cm.getAlpha(pixel)) : new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), 255);
        return actual;
    }
}

