/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class CapabilitiesBBOXForEachCRSTest
extends WMSTestSupport {
    void addSRSAndSetFlag() {
        WMSInfo wms = this.getWMS().getServiceInfo();
        wms.getSRS().add("4326");
        wms.getSRS().add("3005");
        wms.setBBOXForEachCRS(true);
        this.getGeoServer().save((ServiceInfo)wms);
    }

    public void testBBOXForEachCRS() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        String layer = this.getLayerId(MockData.PRIMITIVEGEOFEATURE);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:4326']"), (Document)doc);
        XMLAssert.assertXpathNotExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)doc);
        this.addSRSAndSetFlag();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:4326']"), (Document)doc);
        XMLAssert.assertXpathExists((String)("//Layer[Name='" + layer + "']/BoundingBox[@SRS = 'EPSG:3005']"), (Document)doc);
    }

    public void testRootLayer() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:4326']", (Document)doc);
        XMLAssert.assertXpathNotExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:3005']", (Document)doc);
        this.addSRSAndSetFlag();
        doc = this.getAsDOM("sf/PrimitiveGeoFeature/wms?service=WMS&request=getCapabilities&version=1.1.0", true);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:4326']", (Document)doc);
        XMLAssert.assertXpathExists((String)"/WMT_MS_Capabilities/Capability/Layer/BoundingBox[@SRS = 'EPSG:3005']", (Document)doc);
    }
}

