/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.geotiff;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.geoserver.wms.WMS;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.DefaultRasterMapProducer;

public class GeoTiffMapProducer
extends DefaultRasterMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.geotiff");
    static final String MIME_TYPE = "image/tiff";
    private static final GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
    private static final String[] OUTPUT_FORMATS = new String[]{"image/geotiff", "image/geotiff8"};

    public GeoTiffMapProducer(WMS wms) {
        super(MIME_TYPE, OUTPUT_FORMATS, wms);
    }

    @Override
    public void formatImageOutputStream(RenderedImage image, OutputStream outStream) throws WmsException, IOException {
        String format;
        GridCoverage2D gc = factory.create((CharSequence)"geotiff", image, (Envelope)new GeneralEnvelope((Envelope)this.mapContext.getAreaOfInterest()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image ...");
        }
        if ((format = this.getOutputFormat()).equalsIgnoreCase("image/geotiff8") || this.mapContext.getPaletteInverter() != null) {
            image = this.forceIndexed8Bitmask(image);
        }
        ImageOutputStream imageOutStream = ImageIO.createImageOutputStream(outStream);
        GeoTiffWriter writer = new GeoTiffWriter((Object)imageOutStream);
        writer.write((GridCoverage)gc, null);
        imageOutStream.flush();
        imageOutStream.close();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing tiff image done!");
        }
    }

    @Override
    public String getContentDisposition() {
        return null;
    }
}

