/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CapabilitiesTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new CapabilitiesTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    @Override
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addWellKnownCoverageTypes();
    }

    public void testCapabilities() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities"), false);
        Element e = dom.getDocumentElement();
        CapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)e.getLocalName());
    }

    public void testFilteredCapabilitiesCite() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&namespace=cite"), true);
        Element e = dom.getDocumentElement();
        CapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        CapabilitiesTest.assertTrue((xpath.getMatchingNodes("//Layer/Name[starts-with(., cite)]", dom).getLength() > 0 ? 1 : 0) != 0);
        CapabilitiesTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//Layer/Name[not(starts-with(., cite))]", dom).getLength());
    }

    public void testLayerCount() throws Exception {
        ArrayList layers = new ArrayList(this.getCatalog().getLayers());
        ListIterator it = layers.listIterator();
        while (it.hasNext()) {
            LayerInfo next = (LayerInfo)it.next();
            if (!next.getName().equals(MockData.GEOMETRYLESS.getLocalPart())) continue;
            it.remove();
        }
        Document dom = this.dom(this.get("wms?request=getCapabilities"), true);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        NodeList nodeLayers = xpath.getMatchingNodes("/WMT_MS_Capabilities/Capability/Layer/Layer", dom);
        CapabilitiesTest.assertEquals((int)layers.size(), (int)nodeLayers.getLength());
    }
}

