/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class GetCapabilitiesTest
extends WMSTestSupport {
    @Override
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
    }

    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        GetCapabilitiesTest.assertEquals((String)"WMT_MS_Capabilities", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Name[text()='cite:Buildings'])", (Document)doc);
    }

    public void testAttribution() throws Exception {
        Document doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Attribution)", (Document)doc);
        LayerInfo points = this.getCatalog().getLayerByName(MockData.POINTS.getLocalPart());
        AttributionInfo attr = points.getAttribution();
        attr.setTitle("Point Provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        attr = points.getAttribution();
        attr.setHref("http://example.com/points/provider");
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/OnlineResource)", (Document)doc);
        attr = points.getAttribution();
        attr.setLogoURL("http://example.com/points/logo");
        attr.setLogoType("image/logo");
        attr.setLogoHeight(50);
        attr.setLogoWidth(50);
        this.getCatalog().save(points);
        doc = this.getAsDOM("wms?service=WMS&request=getCapabilities", true);
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/Title)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//Attribution/LogoURL)", (Document)doc);
    }
}

