/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.raster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.SelectedChannelType;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.responses.ImageUtils;
import org.vfny.geoserver.wms.responses.LegendUtils;
import org.vfny.geoserver.wms.responses.legend.raster.Cell;
import org.vfny.geoserver.wms.responses.legend.raster.ClassesEntryLegendBuilder;
import org.vfny.geoserver.wms.responses.legend.raster.ColorMapEntryLegendBuilder;
import org.vfny.geoserver.wms.responses.legend.raster.PackagedUtils;
import org.vfny.geoserver.wms.responses.legend.raster.RampColorMapEntryLegendBuilder;
import org.vfny.geoserver.wms.responses.legend.raster.SingleColorMapEntryLegendBuilder;
import org.vfny.geoserver.wms.responses.legend.raster.TextManager;

class ColorMapLegendCreator {
    private static final Logger LOGGER = Logging.getLogger(ColorMapLegendCreator.class);
    private ColorMapType colorMapType;
    private boolean extended = false;
    private boolean transparent;
    private Dimension requestedDimension;
    private Color backgroundColor;
    private Font labelFont;
    private Color labelFontColor;
    private final Queue<ColorMapEntryLegendBuilder> bodyRows = new LinkedList<ColorMapEntryLegendBuilder>();
    private final List<Cell> footerRows = new ArrayList<Cell>();
    private LegendUtils.HAlign hAlign = LegendUtils.HAlign.LEFT;
    private LegendUtils.VAlign vAlign = LegendUtils.VAlign.BOTTOM;
    private double vMarginPercentage = 0.015f;
    private double hMarginPercentage = 0.015f;
    private double rowMarginPercentage = 0.15f;
    private double columnMarginPercentage = 0.15f;
    private Color borderColor = LegendUtils.DEFAULT_BORDER_COLOR;
    private boolean borderLabel = false;
    private boolean borderRule = false;
    private double margin;
    private double rowH;
    private double colorW;
    private double ruleW;
    private double labelW;
    private double footerW;
    private String grayChannelName = "1";
    private boolean fontAntiAliasing = true;
    private boolean forceRule = false;
    private BufferedImage legend;
    private boolean border = false;
    private double dx;
    private double dy;

    public ColorMapLegendCreator(Builder builder) {
        this.backgroundColor = builder.backgroundColor;
        this.bodyRows.addAll(builder.bodyRows);
        this.border = builder.border;
        this.borderColor = builder.borderColor;
        this.borderLabel = builder.borderLabel;
        this.borderRule = builder.borderRule;
        this.colorMapType = builder.colorMapType;
        this.columnMarginPercentage = builder.columnMarginPercentage;
        this.extended = builder.extended;
        this.fontAntiAliasing = builder.fontAntiAliasing;
        this.forceRule = builder.forceRule;
        this.grayChannelName = builder.grayChannelName;
        this.hAlign = builder.hAlign;
        this.vAlign = builder.vAlign;
        this.labelFont = builder.labelFont;
        this.labelFontColor = builder.labelFontColor;
        this.rowMarginPercentage = builder.rowMarginPercentage;
        this.columnMarginPercentage = builder.columnMarginPercentage;
        this.hMarginPercentage = builder.hMarginPercentage;
        this.vMarginPercentage = builder.vMarginPercentage;
        this.requestedDimension = (Dimension)builder.requestedDimension.clone();
        this.transparent = builder.transparent;
    }

    public synchronized BufferedImage getLegend() {
        if (this.legend == null) {
            this.init();
            Queue<BufferedImage> body = this.createBody();
            Queue<BufferedImage> footer = this.createFooter();
            body.addAll(footer);
            this.legend = this.mergeRows(body);
        }
        return this.legend;
    }

    private void init() {
        BufferedImage image = ImageUtils.createImage(1, 1, null, this.transparent);
        HashMap hintsMap = new HashMap();
        Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, image, hintsMap);
        this.rowH = Double.NEGATIVE_INFINITY;
        this.colorW = Double.NEGATIVE_INFINITY;
        this.ruleW = Double.NEGATIVE_INFINITY;
        this.labelW = Double.NEGATIVE_INFINITY;
        this.cycleBodyRows(graphics);
        String bandNameString = "Band selection is " + this.grayChannelName;
        this.footerRows.add(new TextManager(bandNameString, this.vAlign, this.hAlign, this.backgroundColor, this.requestedDimension, this.labelFont, this.labelFontColor, this.fontAntiAliasing, this.borderColor));
        String colorMapTypeString = "ColorMap type is " + this.colorMapType.toString();
        this.footerRows.add(new TextManager(colorMapTypeString, this.vAlign, this.hAlign, this.backgroundColor, this.requestedDimension, this.labelFont, this.labelFontColor, this.fontAntiAliasing, this.borderColor));
        String extendedCMapString = "ColorMap is " + (this.extended ? "" : "not") + " extended";
        this.footerRows.add(new TextManager(extendedCMapString, this.vAlign, this.hAlign, this.backgroundColor, this.requestedDimension, this.labelFont, this.labelFontColor, this.fontAntiAliasing, this.borderColor));
        this.cycleFooterRows(graphics);
        double maxW = Math.max(Math.max(Math.max(this.colorW, this.ruleW), this.labelW), this.footerW);
        this.dx = maxW * this.columnMarginPercentage;
        this.dy = this.colorMapType == ColorMapType.RAMP ? 0.0 : this.rowH * this.rowMarginPercentage;
        double mx = maxW * this.hMarginPercentage;
        double my = this.rowH * this.vMarginPercentage;
        this.margin = Math.max(mx, my);
    }

    private void cycleFooterRows(Graphics2D graphics) {
        int numRows = this.footerRows.size();
        int i = 0;
        this.footerW = Double.NEGATIVE_INFINITY;
        for (i = 0; i < numRows; ++i) {
            Cell cell = this.footerRows.get(i);
            Dimension cellDim = cell.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, cellDim.getHeight());
            this.footerW = Math.max(this.footerW, cellDim.getWidth());
        }
    }

    private void cycleBodyRows(Graphics2D graphics) {
        for (ColorMapEntryLegendBuilder row : this.bodyRows) {
            Cell labelM;
            Cell cm = row.getColorManager();
            Dimension colorDim = cm.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, colorDim.getHeight());
            this.colorW = Math.max(this.colorW, colorDim.getWidth());
            if (this.forceRule) {
                Cell ruleM = row.getRuleManager();
                Dimension ruleDim = ruleM.getPreferredDimension(graphics);
                this.rowH = Math.max(this.rowH, ruleDim.getHeight());
                this.ruleW = Math.max(this.ruleW, ruleDim.getWidth());
            }
            if ((labelM = row.getLabelManager()) == null) continue;
            Dimension labelDim = labelM.getPreferredDimension(graphics);
            this.rowH = Math.max(this.rowH, labelDim.getHeight());
            this.labelW = Math.max(this.labelW, labelDim.getWidth());
        }
    }

    private Queue<BufferedImage> createFooter() {
        BufferedImage image = ImageUtils.createImage(1, 1, null, this.transparent);
        HashMap hintsMap = new HashMap();
        Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, image, hintsMap);
        LinkedList<BufferedImage> queue = new LinkedList<BufferedImage>();
        int rowWidth = (int)Math.round(this.footerW);
        for (Cell cell : this.footerRows) {
            Dimension dim = cell.getPreferredDimension(graphics);
            int rowHeight = (int)Math.round(dim.getHeight());
            Rectangle clipboxA = new Rectangle(0, 0, rowWidth, rowHeight);
            BufferedImage colorCellLegend = new BufferedImage(rowWidth, rowHeight, 2);
            Graphics2D rlg = colorCellLegend.createGraphics();
            rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            cell.draw(rlg, clipboxA, this.border);
            rlg.dispose();
            queue.add(colorCellLegend);
        }
        graphics.dispose();
        return queue;
    }

    private Queue<BufferedImage> createBody() {
        LinkedList<BufferedImage> queue = new LinkedList<BufferedImage>();
        int rowHeight = (int)Math.round(this.rowH);
        int colorWidth = (int)Math.round(this.colorW);
        int ruleWidth = (int)Math.round(this.ruleW);
        int labelWidth = (int)Math.round(this.labelW);
        Rectangle clipboxA = new Rectangle(0, 0, colorWidth, rowHeight);
        Rectangle clipboxB = new Rectangle(0, 0, ruleWidth, rowHeight);
        Rectangle clipboxC = new Rectangle(0, 0, labelWidth, rowHeight);
        for (ColorMapEntryLegendBuilder row : this.bodyRows) {
            Cell colorCell = row.getColorManager();
            BufferedImage colorCellLegend = new BufferedImage(colorWidth, rowHeight, 2);
            Graphics2D rlg = colorCellLegend.createGraphics();
            rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            colorCell.draw(rlg, clipboxA, this.border);
            rlg.dispose();
            BufferedImage ruleCellLegend = null;
            if (this.forceRule) {
                Cell ruleCell = row.getRuleManager();
                ruleCellLegend = new BufferedImage(ruleWidth, rowHeight, 2);
                rlg = ruleCellLegend.createGraphics();
                rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ruleCell.draw(rlg, clipboxB, this.borderRule);
                rlg.dispose();
            }
            if (labelWidth > 0) {
                Cell labelCell = row.getLabelManager();
                if (labelCell != null) {
                    BufferedImage labelCellLegend = new BufferedImage(labelWidth, rowHeight, 2);
                    rlg = labelCellLegend.createGraphics();
                    rlg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    rlg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    labelCell.draw(rlg, clipboxC, this.borderLabel);
                    rlg.dispose();
                    HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
                    queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, labelCellLegend, hintsMap, this.transparent, this.backgroundColor, this.dx));
                    continue;
                }
                HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
                queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, null, hintsMap, this.transparent, this.backgroundColor, this.dx));
                continue;
            }
            HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
            queue.add(LegendUtils.hMergeBufferedImages(colorCellLegend, ruleCellLegend, null, hintsMap, this.transparent, this.backgroundColor, this.dx));
        }
        return queue;
    }

    private BufferedImage mergeRows(Queue<BufferedImage> legendsQueue) {
        Dimension finalDimension = new Dimension();
        int numRows = legendsQueue.size();
        finalDimension.setSize(Math.max(this.footerW, this.colorW + this.ruleW + this.labelW) + 2.0 * this.dx + 2.0 * this.margin, this.rowH * (double)numRows + 2.0 * this.margin + (double)(numRows - 1) * this.dy);
        int totalWidth = (int)finalDimension.getWidth();
        int totalHeight = (int)finalDimension.getHeight();
        BufferedImage finalLegend = ImageUtils.createImage(totalWidth, totalHeight, null, this.transparent);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D finalGraphics = ImageUtils.prepareTransparency(this.transparent, this.backgroundColor, finalLegend, hintsMap);
        hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        finalGraphics.setRenderingHints(hintsMap);
        int topOfRow = (int)(this.margin + 0.5);
        for (int i = 0; i < numRows; ++i) {
            BufferedImage img = legendsQueue.remove();
            finalGraphics.drawImage((Image)img, (int)(this.margin + 0.5), topOfRow, null);
            topOfRow = (int)((double)topOfRow + ((double)img.getHeight() + this.dy));
        }
        finalGraphics.dispose();
        return finalLegend;
    }

    static enum ColorMapType {
        UNIQUE_VALUES,
        RAMP,
        CLASSES;


        public static ColorMapType create(String value) {
            if (value.equalsIgnoreCase("intervals")) {
                return CLASSES;
            }
            if (value.equalsIgnoreCase("ramp")) {
                return RAMP;
            }
            if (value.equalsIgnoreCase("values")) {
                return UNIQUE_VALUES;
            }
            return ColorMapType.valueOf(value);
        }

        public static ColorMapType create(int value) {
            switch (value) {
                case 2: {
                    return CLASSES;
                }
                case 1: {
                    return RAMP;
                }
                case 3: {
                    return UNIQUE_VALUES;
                }
            }
            throw new IllegalArgumentException("Unable to create ColorMapType for value " + value);
        }
    }

    static class Builder {
        private final Queue<ColorMapEntryLegendBuilder> bodyRows = new LinkedList<ColorMapEntryLegendBuilder>();
        private ColorMapType colorMapType;
        private ColorMapEntry previousCMapEntry;
        private final Map<String, Object> additionalOptions = new HashMap<String, Object>();
        private Color backgroundColor;
        private String grayChannelName = "1";
        private boolean extended = false;
        private Color borderColor = LegendUtils.DEFAULT_BORDER_COLOR;
        private boolean fontAntiAliasing = true;
        private LegendUtils.HAlign hAlign = LegendUtils.HAlign.LEFT;
        private Font labelFont;
        private Color labelFontColor;
        private Dimension requestedDimension;
        private boolean transparent;
        private LegendUtils.VAlign vAlign = LegendUtils.VAlign.BOTTOM;
        private boolean forceRule = false;
        private double rowMarginPercentage = 0.15f;
        private double vMarginPercentage = 0.015f;
        private double columnMarginPercentage = 0.15f;
        private double hMarginPercentage = 0.015f;
        private boolean border = false;
        private boolean borderLabel = false;
        private boolean borderRule = false;

        Builder() {
        }

        public void addColorMapEntry(ColorMapEntry cEntry) {
            ColorMapEntryLegendBuilder element;
            PackagedUtils.ensureNotNull(cEntry, "cEntry");
            switch (this.colorMapType) {
                case UNIQUE_VALUES: {
                    element = new SingleColorMapEntryLegendBuilder(Arrays.asList(cEntry), this.hAlign, this.vAlign, this.backgroundColor, 1.0, this.grayChannelName, this.requestedDimension, this.labelFont, this.labelFontColor, this.extended, this.borderColor);
                    break;
                }
                case RAMP: {
                    element = new RampColorMapEntryLegendBuilder(Arrays.asList(this.previousCMapEntry, cEntry), this.hAlign, this.vAlign, this.backgroundColor, 1.0, this.grayChannelName, this.requestedDimension, this.labelFont, this.labelFontColor, this.extended, this.borderColor);
                    break;
                }
                case CLASSES: {
                    element = new ClassesEntryLegendBuilder(Arrays.asList(this.previousCMapEntry, cEntry), this.hAlign, this.vAlign, this.backgroundColor, 1.0, this.grayChannelName, this.requestedDimension, this.labelFont, this.labelFontColor, this.extended, this.borderColor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized colormap type");
                }
            }
            this.bodyRows.add(element);
            this.previousCMapEntry = cEntry;
        }

        public void setAdditionalOptions(Map<String, Object> legendOptions) {
            this.additionalOptions.putAll(legendOptions);
        }

        public void setBackgroundColor(Color backGroundColor) {
            PackagedUtils.ensureNotNull(backGroundColor, "backGroundColor");
            this.backgroundColor = backGroundColor;
        }

        public void setBand(SelectedChannelType grayChannel) {
            if (grayChannel != null) {
                this.grayChannelName = grayChannel.getChannelName();
            }
            if (this.grayChannelName == null) {
                this.grayChannelName = "1";
            }
        }

        public void setColorMapType(ColorMapType colorMapType) {
            this.colorMapType = colorMapType;
        }

        public void setColorMapType(int type) {
            this.colorMapType = ColorMapType.create(type);
        }

        public void setExtended(boolean extended) {
            this.extended = extended;
        }

        public void setLabelFont(Font labelFont) {
            PackagedUtils.ensureNotNull(labelFont, "labelFont");
            this.labelFont = labelFont;
        }

        public void setLabelFontColor(Color labelFontColor) {
            PackagedUtils.ensureNotNull(labelFontColor, "labelFontColor");
            this.labelFontColor = labelFontColor;
        }

        public void setRequestedDimension(Dimension dimension) {
            this.requestedDimension = (Dimension)dimension.clone();
        }

        public void setTransparent(boolean transparent) {
            this.transparent = transparent;
        }

        public void setBorderLabel(boolean borderLabel) {
            this.borderLabel = borderLabel;
        }

        public void setBorderRule(boolean borderRule) {
            this.borderRule = borderRule;
        }

        public ColorMapLegendCreator create() {
            return new ColorMapLegendCreator(this);
        }

        void checkAdditionalOptions() {
            String aaVal;
            this.fontAntiAliasing = false;
            if (this.additionalOptions.get("fontAntiAliasing") instanceof String && ((aaVal = (String)this.additionalOptions.get("fontAntiAliasing")).equalsIgnoreCase("on") || aaVal.equalsIgnoreCase("true") || aaVal.equalsIgnoreCase("yes") || aaVal.equalsIgnoreCase("1"))) {
                this.fontAntiAliasing = true;
            }
            if (this.additionalOptions.get("dx") instanceof String) {
                this.columnMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("dx"));
            }
            if (this.additionalOptions.get("dy") instanceof String) {
                this.rowMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("dy"));
            }
            if (this.additionalOptions.get("mx") instanceof String) {
                this.hMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("mx"));
            }
            if (this.additionalOptions.get("my") instanceof String) {
                this.vMarginPercentage = Double.parseDouble((String)this.additionalOptions.get("my"));
            }
            if (this.additionalOptions.get("borderColor") instanceof String) {
                this.borderColor = LegendUtils.color((String)this.additionalOptions.get("borderColor"));
            }
            if (this.additionalOptions.get("border") instanceof String) {
                this.border = Boolean.valueOf((String)this.additionalOptions.get("border"));
            }
            if (this.additionalOptions.get("forceRule") instanceof String) {
                this.forceRule = Boolean.parseBoolean((String)this.additionalOptions.get("forceRule"));
            }
            if (!this.forceRule) {
                for (ColorMapEntryLegendBuilder row : this.bodyRows) {
                    Cell labelM = row.getLabelManager();
                    if (labelM == null) {
                        this.forceRule = true;
                        continue;
                    }
                    this.forceRule = false;
                    break;
                }
            }
        }
    }
}

