/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Point;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geotools.map.MapLayer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.GeometryRegionatingStrategy;
import org.vfny.geoserver.wms.responses.map.kml.RandomRegionatingStrategy;
import org.vfny.geoserver.wms.responses.map.kml.RegionatingStrategy;

public class BestGuessRegionatingStrategy
implements RegionatingStrategy {
    GeoServer gs;

    public BestGuessRegionatingStrategy(GeoServer gs) {
        this.gs = gs;
    }

    @Override
    public Filter getFilter(WMSMapContext context, MapLayer layer) {
        SimpleFeatureType type = (SimpleFeatureType)layer.getFeatureSource().getSchema();
        Class geomtype = type.getGeometryDescriptor().getType().getBinding();
        if (Point.class.isAssignableFrom(geomtype)) {
            return new RandomRegionatingStrategy(this.gs).getFilter(context, layer);
        }
        return new GeometryRegionatingStrategy(this.gs).getFilter(context, layer);
    }

    @Override
    public void clearCache(FeatureTypeInfo cfg) {
        new GeometryRegionatingStrategy(this.gs).clearCache(cfg);
    }
}

