/* Copyright (c) 2001, 2007 TOPP - www.openplans.org. All rights reserved.
 * This code is licensed under the GPL 2.0 license, availible at the root
 * application directory.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.image.RenderedImage;

import org.vfny.geoserver.wms.RasterMapProducer;


/**
 *
 * @author Simone Giannecchini, GeoSolutions
 *
 */
public abstract class AbstractRasterMapProducer extends AbstractGetMapProducer
    implements RasterMapProducer {
    /**
     * The image generated by the execute method.
     */
    protected RenderedImage image;

    /**
     * Constructor that assumes MIME Type and a single output format name 
     * equal to the MIME Type
     * 
     * @param mime the MIME Type this producer creates the map in
     */
    public AbstractRasterMapProducer(String mime) {
        super(mime, mime);
    }

    /**
     * 
     * @param mime the MIME Type this producer creates the map in
     * @param outputFormats the names of the output format to state in capabilities
     */
    public AbstractRasterMapProducer(String mime, String[] outputFormats) {
        super(mime, outputFormats);
    }

    /**
    * This is a package protected method with the sole purpose of facilitate
    * unit testing. Do not use by any means for oher purposes.
    *
    * @return DOCUMENT ME!
    */
    public RenderedImage getImage() {
        return this.image;
    }
}
