/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.filter.function;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorRampFunction
implements Function {
    private static final float EPS = 1.0E-6f;
    private static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private String name = "ColorRamp";
    private List<Expression> paramList = new ArrayList<Expression>();
    private final Literal fallback = filterFactory.literal((Object)Color.GRAY);
    private float minValue;
    private float maxValue;
    private float saturation;
    private float brightness;

    public ColorRampFunction(Expression valueExpr, float minValue, float maxValue, float saturation, float brightness) {
        if (minValue - maxValue > -1.0E-6f) {
            throw new IllegalArgumentException("minValue must be greater than maxValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        if ((double)saturation < 0.0 || (double)saturation > 1.0 || (double)brightness < 0.0 || (double)brightness > 1.0) {
            throw new IllegalArgumentException("saturation and brightness must between 0 and 1");
        }
        this.saturation = saturation;
        this.brightness = brightness;
        this.paramList.add(valueExpr);
    }

    public String getName() {
        return this.name;
    }

    public List<Expression> getParameters() {
        return this.paramList;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public Object evaluate(Object feature) {
        float value = ((Number)this.getParameters().get(0).evaluate(feature)).floatValue();
        System.out.println("value = " + value);
        return this.valueToColor(value);
    }

    public <T> T evaluate(Object feature, Class<T> clazz) {
        if (Color.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.evaluate(feature));
        }
        throw new UnsupportedOperationException("Color is the only supported class");
    }

    public Object accept(ExpressionVisitor visitor, Object arg) {
        return visitor.visit((Function)this, arg);
    }

    private Color valueToColor(float value) {
        float hue = (value - this.minValue) / (this.maxValue - this.minValue);
        if (hue < 0.0f || hue > 1.0f) {
            return null;
        }
        int rgb = Color.HSBtoRGB(hue * 0.5f, this.saturation, this.brightness);
        return new Color(rgb);
    }
}

