/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultRepository;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapFrame;
import org.geotools.swing.JMapPane;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.geotools.swing.styling.JSimpleStyleDialog;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileViewer
extends JMapFrame {
    private DefaultRepository repository = new DefaultRepository();
    private MapContext context;
    private String title;
    private File cwd;

    public static void main(String[] args) {
        ShapefileViewer viewer = new ShapefileViewer("Shapefile viewer");
        File dataDir = new File(ShapefileViewer.class.getResource("/data").getPath());
        viewer.setWorkingDir(dataDir);
        viewer.setSize(800, 600);
        viewer.setVisible(true);
    }

    public ShapefileViewer(String title) {
        this.title = title;
        this.enableLayerTable(true);
        this.enableStatusBar(true);
        this.enableToolBar(true);
        this.initComponents();
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("Open...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ShapefileViewer.this.loadShapefile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("Get scale");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AffineTransform tr;
                JMapPane mapPane = ShapefileViewer.this.getMapPane();
                if (mapPane != null && (tr = mapPane.getScreenToWorldTransform()) != null) {
                    System.out.println("x scale: " + tr.getScaleX());
                    System.out.println("Y scale: " + tr.getScaleY());
                    System.out.println("pane area: " + mapPane.getVisibleRect());
                }
            }
        });
        menu.add(item);
        menuBar.add(menu);
    }

    public void setWorkingDir(File cwd) {
        if (!cwd.isDirectory()) {
            throw new IllegalArgumentException("The argument is not a directory: " + cwd.getAbsolutePath());
        }
        this.cwd = cwd;
    }

    public void loadShapefile() throws IOException {
        File file = JFileDataStoreChooser.showOpenFile((String)"shp", (File)this.cwd, null);
        if (file != null) {
            this.addShapefile(file.toURL(), true);
            this.setWorkingDir(file.getParentFile());
        }
    }

    public boolean addShapefile(URL shapefileURL, boolean defaultStyle) throws IOException {
        if (shapefileURL == null) {
            throw new IllegalArgumentException("shapefileURL must not me null");
        }
        ShapefileDataStore dstore = null;
        DataStore found = this.repository.dataStore(shapefileURL.toString());
        if (found != null && found instanceof ShapefileDataStore) {
            dstore = (ShapefileDataStore)found;
        } else {
            try {
                dstore = new ShapefileDataStore(shapefileURL);
            }
            catch (MalformedURLException urlEx) {
                throw new RuntimeException(urlEx);
            }
            this.repository.register(shapefileURL.toString(), (DataAccess)dstore);
        }
        dstore.getSchema();
        String typeName = dstore.getTypeNames()[0];
        Style style = null;
        URL sldURL = this.getShapefileSLD(shapefileURL);
        if (sldURL != null) {
            StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
            SLDParser stylereader = new SLDParser(factory, sldURL);
            style = stylereader.readXML()[0];
        } else if (defaultStyle) {
            style = JSimpleStyleDialog.showDialog((Component)((Object)this), (AbstractDataStore)dstore);
            if (style == null) {
                return false;
            }
        } else {
            return false;
        }
        DefaultMapLayer layer = new DefaultMapLayer(dstore.getFeatureSource(typeName), style);
        this.addLayer((MapLayer)layer);
        return true;
    }

    public boolean addShapefile(URL shapefileURL, Style style) throws IOException {
        if (shapefileURL == null || style == null) {
            throw new IllegalArgumentException("shapefileURL must not be null");
        }
        ShapefileDataStore dstore = null;
        DataStore found = this.repository.dataStore(shapefileURL.toString());
        if (found != null && found instanceof ShapefileDataStore) {
            dstore = (ShapefileDataStore)found;
        } else {
            try {
                dstore = new ShapefileDataStore(shapefileURL);
            }
            catch (MalformedURLException urlEx) {
                throw new RuntimeException(urlEx);
            }
            this.repository.register(shapefileURL.toString(), (DataAccess)dstore);
        }
        dstore.getSchema();
        String typeName = dstore.getTypeNames()[0];
        DefaultMapLayer layer = new DefaultMapLayer(dstore.getFeatureSource(typeName), style);
        this.addLayer((MapLayer)layer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getShapefileSLD(URL shapefileURL) {
        File shapefile;
        URL sldURL = null;
        try {
            shapefile = new File(shapefileURL.toURI());
        }
        catch (URISyntaxException e) {
            shapefile = new File(shapefileURL.getPath());
        }
        String fileName = shapefile.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            File directory = shapefile.getParentFile();
            String sldname1 = fileName.substring(0, lastDot) + ".sld";
            String sldname2 = fileName.substring(0, lastDot) + ".SLD";
            InputStream input = null;
            try {
                File sldFile1 = new File(directory, sldname1);
                File sldFile2 = new File(directory, sldname2);
                if (sldFile1.exists() && sldFile1.canRead()) {
                    sldURL = sldFile1.toURL();
                } else if (sldFile1.exists() && sldFile1.canRead()) {
                    sldURL = sldFile2.toURL();
                } else {
                    URL uRL = null;
                    return uRL;
                }
                input = sldURL.openStream();
            }
            catch (MalformedURLException urlEx) {
                throw new RuntimeException(urlEx);
            }
            catch (IOException ioEx) {
                URL uRL = null;
                return uRL;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return sldURL;
    }

    public void addLayer(MapLayer layer) {
        if (this.context == null) {
            CoordinateReferenceSystem crs = layer.getBounds().getCoordinateReferenceSystem();
            if (crs == null) {
                crs = DefaultGeographicCRS.WGS84;
            }
            this.context = new DefaultMapContext(crs);
            this.context.setTitle(this.title);
            this.setMapContext(this.context);
            this.setRenderer((GTRenderer)new StreamingRenderer());
        }
        this.context.addLayer(layer);
    }
}

