/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.filter.function;

import java.net.URL;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.demo.filter.function.ColorRampFunction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapFrame;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DynamicFillColor {
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);

    public Style createColorRampStyle(String attrName, float minValue, float maxValue, boolean logValues) {
        Style style = this.styleFactory.createStyle();
        Object valueExpr = null;
        valueExpr = logValues ? this.filterFactory.function("log", new Expression[]{this.filterFactory.property(attrName)}) : this.filterFactory.property(attrName);
        ColorRampFunction fn = new ColorRampFunction((Expression)valueExpr, minValue, maxValue, 0.8f, 0.8f);
        Fill fill = this.styleFactory.createFill((Expression)fn);
        Stroke stroke = this.styleFactory.createStroke((Expression)fn, (Expression)this.filterFactory.literal(1.0));
        PolygonSymbolizer symbolizer = this.styleFactory.createPolygonSymbolizer(stroke, fill, "the_geom");
        Rule rule = this.styleFactory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        style.featureTypeStyles().add(fts);
        return style;
    }

    public static void main(String[] args) throws Exception {
        DynamicFillColor me = new DynamicFillColor();
        me.demo();
    }

    private void demo() throws Exception {
        URL url = DynamicFillColor.class.getResource("/data/shapefiles/countries.shp");
        ShapefileDataStore shapefile = new ShapefileDataStore(url);
        String typeName = shapefile.getTypeNames()[0];
        FeatureSource featureSource = shapefile.getFeatureSource(typeName);
        FeatureType schema = featureSource.getSchema();
        CoordinateReferenceSystem crs = schema.getCoordinateReferenceSystem();
        Style style = this.createColorRampStyle("POP_CNTRY", 5.0f, 22.0f, true);
        DefaultMapContext map = new DefaultMapContext(crs);
        map.addLayer(featureSource, style);
        JMapFrame.showMap((MapContext)map);
    }
}

