/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.referencing;

import java.util.HashMap;
import javax.measure.unit.SI;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.DefiningConversion;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Conversion;

public class CRSDemo {
    public void create_ProjectedCRS_from_DefaultGeogCRS() {
        DefiningConversion dc;
        System.out.println("Start: Create ProjectedCRS from DefaultGeographicCRS.\n");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "My arbitrary name");
        DefaultGeographicCRS geogCRS = DefaultGeographicCRS.WGS84;
        String dcName = "A Mercator";
        DefaultMathTransformFactory mtf = new DefaultMathTransformFactory();
        ParameterValueGroup pvg = null;
        try {
            pvg = mtf.getDefaultParameters("Mercator_1SP");
        }
        catch (NoSuchIdentifierException nsiex) {
            System.err.println("On DefaultPrameterGroup creation: " + nsiex.getMessage());
        }
        DefiningConversion c = dc = new DefiningConversion("A Mercator", pvg);
        HashMap<String, String> map = new HashMap<String, String>();
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory(null);
        CoordinateSystemAxis xAxis = null;
        CoordinateSystemAxis yAxis = null;
        CartesianCS worldCS = null;
        try {
            map.clear();
            map.put("name", "Cartesian X axis");
            xAxis = csFactory.createCoordinateSystemAxis(map, "X", AxisDirection.EAST, SI.METER);
            map.clear();
            map.put("name", "Cartesian Y axis");
            yAxis = csFactory.createCoordinateSystemAxis(map, "Y", AxisDirection.NORTH, SI.METER);
            map.clear();
            map.put("name", "Cartesian CS");
            worldCS = csFactory.createCartesianCS(map, xAxis, yAxis);
        }
        catch (FactoryException fex) {
            System.err.println("On cartesianCS creation: " + fex.getMessage());
        }
        ReferencingFactoryContainer fg = ReferencingFactoryContainer.instance(null);
        try {
            ProjectedCRS projCRS = fg.createProjectedCRS(props, (GeographicCRS)DefaultGeographicCRS.WGS84, (Conversion)c, worldCS);
        }
        catch (FactoryException fex) {
            System.err.println("On projectedCRS creation: " + fex.getMessage());
        }
    }
}

