/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.metadata.example;

import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.metadata.iso.citation.TelephoneImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;

public class MetadataExample {
    public static void referenceDocument(Citation citation) {
        System.out.println(citation.getTitle());
        System.out.println(citation.getTitle().toString(Locale.FRENCH));
        System.out.println(citation.getIdentifiers());
        System.out.println(citation.getAlternateTitles());
    }

    public static void telephone() {
        TelephoneImpl phone = new TelephoneImpl();
        phone.setVoices(Collections.singleton("555-1234"));
        phone.setFacsimiles(Collections.singleton("555-2FAX"));
        System.out.println(phone);
    }

    public static void wkt() {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        System.out.println(crs.toWKT());
    }

    public static void main(String[] args) {
        MetadataExample.referenceDocument(Citations.EPSG);
        MetadataExample.referenceDocument(Citations.OGC);
        MetadataExample.referenceDocument(Citations.ORACLE);
        CitationImpl citation = new CitationImpl();
        citation.setEditionDate(new Date());
        Set<ResponsibleParty> parties = Collections.singleton(ResponsiblePartyImpl.GEOTOOLS);
        citation.setCitedResponsibleParties(parties);
        MetadataExample.referenceDocument(Citations.ORACLE);
        MetadataExample.telephone();
        MetadataExample.wkt();
    }
}

