/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.util.Converters;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.xml.sax.helpers.NamespaceSupport;

public class VocabFunctionsTest
extends TestCase {
    private DataAccess<FeatureType, Feature> dataAccess;
    private FeatureCollection<FeatureType, Feature> exCollection;
    private FilterFactory ff;

    public void setUp() throws Exception {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("ex", "http://example.com");
        namespaces.declarePrefix("gml", "http://www.opengis.net/gml");
        this.ff = new FilterFactoryImplNamespaceAware(namespaces);
        Name EXAMPLE_TYPE = Types.typeName((String)"http://example.com", (String)"FirstParentFeature");
        String schemaBase = "/test-data/";
        HashMap<String, String> dsParams = new HashMap<String, String>();
        dsParams.put("dbtype", "app-schema");
        URL url = ((Object)((Object)this)).getClass().getResource("/test-data/VocabFunctionsTest.xml");
        VocabFunctionsTest.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        this.dataAccess = DataAccessFinder.getDataStore(dsParams);
        FeatureSource fSource = this.dataAccess.getFeatureSource(EXAMPLE_TYPE);
        this.exCollection = fSource.getFeatures();
        VocabFunctionsTest.assertEquals((int)this.exCollection.size(), (int)3);
    }

    public void tearDown() {
        this.dataAccess.dispose();
    }

    public void testRecodeFunction() throws IOException {
        HashMap<String, String> VALUE_MAP = new HashMap<String, String>(){
            {
                this.put("1", "a");
                this.put("2", "b");
                this.put("3", "c");
            }
        };
        Iterator features = this.exCollection.iterator();
        while (features.hasNext()) {
            Feature feature = (Feature)features.next();
            String fId = feature.getIdentifier().getID();
            String recodedName = (String)VALUE_MAP.get(fId);
            ComplexAttribute complexAttribute = (ComplexAttribute)this.ff.property("gml:name[3]").evaluate((Object)feature);
            String value = (String)Converters.convert((Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute), String.class);
            VocabFunctionsTest.assertEquals((String)recodedName, (String)value);
        }
        this.exCollection.close(features);
    }

    public void testCategorizeFunction() {
        HashMap<String, String> VALUE_MAP = new HashMap<String, String>(){
            {
                this.put("1", "missing value");
                this.put("2", "a valid value");
                this.put("3", "a valid value");
            }
        };
        Iterator features = this.exCollection.iterator();
        while (features.hasNext()) {
            Feature feature = (Feature)features.next();
            String fId = feature.getIdentifier().getID();
            Property attribute = feature.getProperty("someAttribute");
            VocabFunctionsTest.assertEquals((Object)attribute.getValue(), VALUE_MAP.get(fId));
        }
        this.exCollection.close(features);
    }

    public void testVocabFunction() {
        URL file = ((Object)((Object)this)).getClass().getResource("/test-data/minoc_lithology_mapping.properties");
        VocabFunctionsTest.assertNotNull((Object)file);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Function function = ff.function("Vocab", new Expression[]{ff.literal((Object)"1LIST"), ff.literal((Object)DataUtilities.urlToFile((URL)file).getPath())});
        Object value = function.evaluate(null);
        VocabFunctionsTest.assertEquals((Object)"urn:cgi:classifier:CGI:SimpleLithology:2008:calcareous_carbonate_sedimentary_rock", (Object)value);
    }

    public void testNoVocabFunction() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Function function = ff.function("Vocab", new Expression[]{ff.literal((Object)"a"), ff.literal((Object)"urn:1234")});
        try {
            function.evaluate(null);
            VocabFunctionsTest.fail((String)"Should not be able to get this far");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testVocabFunctionInMappingFile() {
        HashMap<String, String> VALUE_MAP = new HashMap<String, String>(){
            {
                this.put("1", "urn:cgi:classifier:CGI:SimpleLithology:2008:gravel");
                this.put("2", "urn:cgi:classifier:CGI:SimpleLithology:2008:diamictite");
                this.put("3", "urn:cgi:classifier:CGI:SimpleLithology:2008:sediment");
            }
        };
        Iterator features = this.exCollection.iterator();
        while (features.hasNext()) {
            Feature feature = (Feature)features.next();
            String fId = feature.getIdentifier().getID();
            ComplexAttribute complexAttribute = (ComplexAttribute)this.ff.property("gml:name[2]").evaluate((Object)feature);
            String value = (String)Converters.convert((Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute), String.class);
            VocabFunctionsTest.assertEquals((String)((String)VALUE_MAP.get(fId)), (String)value);
        }
        this.exCollection.close(features);
    }
}

