/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.util.Collections;
import java.util.Map;
import org.geotools.data.complex.filter.XPath;
import org.geotools.util.Utilities;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeMapping {
    private Expression identifierExpression;
    private Expression sourceExpression;
    private XPath.StepList targetXPath;
    private boolean isMultiValued;
    AttributeType targetNodeInstance;
    private Map<Name, Expression> clientProperties;

    public AttributeMapping(Expression idExpression, Expression sourceExpression, XPath.StepList targetXPath) {
        this(idExpression, sourceExpression, targetXPath, null, false, null);
    }

    public AttributeMapping(Expression idExpression, Expression sourceExpression, XPath.StepList targetXPath, AttributeType targetNodeInstance, boolean isMultiValued, Map<Name, Expression> clientProperties) {
        this.identifierExpression = idExpression == null ? Expression.NIL : idExpression;
        this.sourceExpression = sourceExpression == null ? Expression.NIL : sourceExpression;
        this.isMultiValued = isMultiValued;
        if (this.sourceExpression == null) {
            this.sourceExpression = Expression.NIL;
        }
        this.targetXPath = targetXPath;
        this.targetNodeInstance = targetNodeInstance;
        this.clientProperties = clientProperties == null ? Collections.emptyMap() : clientProperties;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public Expression getSourceExpression() {
        return this.sourceExpression;
    }

    public XPath.StepList getTargetXPath() {
        return this.targetXPath;
    }

    public AttributeType getTargetNodeInstance() {
        return this.targetNodeInstance;
    }

    public boolean isNestedAttribute() {
        return false;
    }

    public boolean isTreeAttribute() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeMapping)) {
            return false;
        }
        AttributeMapping other = (AttributeMapping)o;
        return Utilities.equals((Object)this.identifierExpression, (Object)other.identifierExpression) && Utilities.equals((Object)this.sourceExpression, (Object)other.sourceExpression) && Utilities.equals((Object)((Object)this.targetXPath), (Object)((Object)other.targetXPath)) && Utilities.equals((Object)this.targetNodeInstance, (Object)other.targetNodeInstance);
    }

    public int hashCode() {
        return 37 * this.identifierExpression.hashCode() + 37 * this.sourceExpression.hashCode() ^ this.targetXPath.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AttributeMapping[");
        sb.append("sourceExpression='").append(this.sourceExpression).append("', targetXPath='").append((Object)this.targetXPath);
        if (this.targetNodeInstance != null) {
            sb.append(", target instance type=").append(this.targetNodeInstance);
        }
        sb.append("']");
        return sb.toString();
    }

    public Map<Name, Expression> getClientProperties() {
        return this.clientProperties == null ? Collections.emptyMap() : this.clientProperties;
    }

    public Expression getIdentifierExpression() {
        return this.identifierExpression;
    }

    public void setIdentifierExpression(Expression identifierExpression) {
        this.identifierExpression = identifierExpression;
    }
}

