/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.Types;
import org.geotools.filter.NestedAttributeExpression;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmappingFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    private static final Logger LOGGER = Logging.getLogger((String)UnmappingFilterVisitor.class.getPackage().getName());
    private FeatureTypeMapping mappings;
    private static final FilterFactory2 ff = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);

    public UnmappingFilterVisitor(FeatureTypeMapping mappings) {
        this.mappings = mappings;
    }

    private Filter combineOred(List combinedFilters) {
        switch (combinedFilters.size()) {
            case 0: {
                throw new IllegalArgumentException("No filters to combine");
            }
            case 1: {
                return (Filter)combinedFilters.get(0);
            }
        }
        return ff.or(combinedFilters);
    }

    public Expression[][] visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        List leftExpressions = (List)left.accept((ExpressionVisitor)this, null);
        List rightExpressions = (List)right.accept((ExpressionVisitor)this, null);
        if (leftExpressions.size() == 0) {
            throw new IllegalStateException(left + " mapping not found");
        }
        if (rightExpressions.size() == 0) {
            throw new IllegalStateException(right + " mapping not found");
        }
        Expression[][] product = this.buildExpressionsMatrix(leftExpressions, rightExpressions);
        return product;
    }

    private Expression[][] buildExpressionsMatrix(List leftExpressions, List rightExpressions) {
        Expression[][] product = new Expression[leftExpressions.size() * rightExpressions.size()][2];
        int index = 0;
        for (Expression left : leftExpressions) {
            for (Expression right : rightExpressions) {
                product[index][0] = left;
                product[index][1] = right;
            }
            ++index;
        }
        return product;
    }

    public Expression[][] visitBinarySpatialOp(BinarySpatialOperator filter) {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        List leftExpressions = (List)left.accept((ExpressionVisitor)this, null);
        List rightExpressions = (List)right.accept((ExpressionVisitor)this, null);
        if (leftExpressions.size() == 0) {
            throw new IllegalStateException(left + " mapping not found");
        }
        if (rightExpressions.size() == 0) {
            throw new IllegalStateException(right + " mapping not found");
        }
        Expression[][] product = this.buildExpressionsMatrix(leftExpressions, rightExpressions);
        return product;
    }

    public List visitBinaryLogicOp(BinaryLogicOperator filter) {
        ArrayList<Filter> unrolledFilers = new ArrayList<Filter>();
        try {
            for (Filter next : filter.getChildren()) {
                Filter unrolled = (Filter)next.accept((FilterVisitor)this, null);
                unrolledFilers.add(unrolled);
            }
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return unrolledFilers;
    }

    public Expression[][] visitBinaryExpression(BinaryExpression expression) {
        LOGGER.finest(expression.toString());
        Expression left = expression.getExpression1();
        Expression right = expression.getExpression2();
        List leftExpressions = (List)left.accept((ExpressionVisitor)this, null);
        List rightExpressions = (List)right.accept((ExpressionVisitor)this, null);
        Expression[][] product = this.buildExpressionsMatrix(leftExpressions, rightExpressions);
        return product;
    }

    public Object visit(ExcludeFilter filter, Object arg1) {
        return filter;
    }

    public Object visit(IncludeFilter filter, Object arg1) {
        return filter;
    }

    public Object visit(And filter, Object arg1) {
        List list = this.visitBinaryLogicOp((BinaryLogicOperator)filter);
        And unrolled = ff.and(list);
        return unrolled;
    }

    public Object visit(Id filter, Object arg1) {
        Function fe;
        Set fids = filter.getIdentifiers();
        Name target = this.mappings.getTargetFeature().getName();
        String namespace = target.getNamespaceURI();
        if (namespace == null) {
            namespace = "";
        }
        String name = target.getLocalPart();
        Expression fidExpression = null;
        for (AttributeMapping attMapping : this.mappings.getAttributeMappings()) {
            XPath.Step step;
            QName stepName;
            XPath.StepList targetXPath = attMapping.getTargetXPath();
            if (targetXPath.size() > 1 || !namespace.equals((stepName = (step = (XPath.Step)targetXPath.get(0)).getName()).getNamespaceURI()) || !name.equals(stepName.getLocalPart())) continue;
            fidExpression = attMapping.getIdentifierExpression();
            break;
        }
        if (fidExpression == null) {
            throw new IllegalStateException("No FID expression found for type " + target + ". Did you mean Expression.NIL?");
        }
        if (Expression.NIL.equals(fidExpression)) {
            return filter;
        }
        if (fidExpression instanceof Function && "getID".equalsIgnoreCase((fe = (Function)fidExpression).getName())) {
            LOGGER.finest("Fid mapping points to same ID as source");
            return filter;
        }
        LOGGER.finest("fid mapping expression is " + fidExpression);
        PropertyIsEqualTo unrolled = null;
        try {
            for (Identifier fid : fids) {
                PropertyIsEqualTo comparison = ff.equals(fidExpression, (Expression)ff.literal((Object)fid.toString()));
                LOGGER.finest("Adding unmapped fid filter " + comparison);
                unrolled = unrolled == null ? comparison : ff.or((Filter)unrolled, (Filter)comparison);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "unrolling " + filter, e);
            throw new RuntimeException(e.getMessage());
        }
        LOGGER.finer("unrolled fid filter is " + unrolled);
        return unrolled;
    }

    public Object visit(Not filter, Object arg1) {
        Filter unrolled = (Filter)filter.getFilter().accept((FilterVisitor)this, null);
        unrolled = ff.not(unrolled);
        return unrolled;
    }

    public Object visit(Or filter, Object arg1) {
        List list = this.visitBinaryLogicOp((BinaryLogicOperator)filter);
        Or unrolled = ff.or(list);
        return unrolled;
    }

    public Object visit(PropertyIsBetween filter, Object arg1) {
        Expression expression = filter.getExpression();
        Expression lower = filter.getLowerBoundary();
        Expression upper = filter.getUpperBoundary();
        List expressions = (List)expression.accept((ExpressionVisitor)this, null);
        List lowerExpressions = (List)lower.accept((ExpressionVisitor)this, null);
        List upperExpressions = (List)upper.accept((ExpressionVisitor)this, null);
        int combinedSize = expressions.size() * lowerExpressions.size() * upperExpressions.size();
        ArrayList<PropertyIsBetween> combinedFilters = new ArrayList<PropertyIsBetween>(combinedSize);
        for (Expression floor : lowerExpressions) {
            for (Expression prop : expressions) {
                for (Expression roof : upperExpressions) {
                    PropertyIsBetween newFilter = ff.between(prop, floor, roof);
                    combinedFilters.add(newFilter);
                }
            }
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<PropertyIsEqualTo> combinedFilters = new ArrayList<PropertyIsEqualTo>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            PropertyIsEqualTo unrolled = ff.equals(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<PropertyIsNotEqualTo> combinedFilters = new ArrayList<PropertyIsNotEqualTo>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            PropertyIsNotEqualTo unrolled = ff.notEqual(left, right, filter.isMatchingCase());
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsGreaterThan filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<PropertyIsGreaterThan> combinedFilters = new ArrayList<PropertyIsGreaterThan>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            PropertyIsGreaterThan unrolled = ff.greater(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<PropertyIsGreaterThanOrEqualTo> combinedFilters = new ArrayList<PropertyIsGreaterThanOrEqualTo>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            PropertyIsGreaterThanOrEqualTo unrolled = ff.greaterOrEqual(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsLessThan filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<PropertyIsLessThan> combinedFilters = new ArrayList<PropertyIsLessThan>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            PropertyIsLessThan unrolled = ff.less(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object arg1) {
        Expression[][] expressions = this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter);
        ArrayList<PropertyIsLessThanOrEqualTo> combinedFilters = new ArrayList<PropertyIsLessThanOrEqualTo>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            PropertyIsLessThanOrEqualTo unrolled = ff.lessOrEqual(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(PropertyIsLike filter, Object arg1) {
        Expression value = filter.getExpression();
        List unrolledValues = (List)value.accept((ExpressionVisitor)this, null);
        String literal = filter.getLiteral();
        String wildcard = filter.getWildCard();
        String single = filter.getSingleChar();
        String escape = filter.getEscape();
        ArrayList<PropertyIsLike> combined = new ArrayList<PropertyIsLike>(unrolledValues.size());
        for (Expression sourceValue : unrolledValues) {
            PropertyIsLike newFilter = ff.like(sourceValue, literal, wildcard, single, escape);
            combined.add(newFilter);
        }
        Filter unrolled = this.combineOred(combined);
        return unrolled;
    }

    public Object visit(PropertyIsNull filter, Object arg1) {
        Expression nullCheck = filter.getExpression();
        List sourceChecks = (List)nullCheck.accept((ExpressionVisitor)this, null);
        ArrayList<PropertyIsNull> combined = new ArrayList<PropertyIsNull>(sourceChecks.size());
        for (Expression sourceValue : sourceChecks) {
            PropertyIsNull newFilter = ff.isNull(sourceValue);
            combined.add(newFilter);
        }
        Filter unrolled = this.combineOred(combined);
        return unrolled;
    }

    public Object visit(BBOX filter, Object arg1) {
        String propertyName = filter.getPropertyName();
        if (propertyName.length() < 1) {
            return filter;
        }
        PropertyName name = ff.property(propertyName);
        List sourceNames = (List)name.accept((ExpressionVisitor)this, null);
        ArrayList<BBOX> combined = new ArrayList<BBOX>(sourceNames.size());
        for (Expression sourceName : sourceNames) {
            BBOX unrolled = ff.bbox(sourceName, filter.getMinX(), filter.getMinY(), filter.getMaxX(), filter.getMaxY(), filter.getSRS());
            combined.add(unrolled);
        }
        Filter unrolled = this.combineOred(combined);
        return unrolled;
    }

    public Object visit(Beyond filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Beyond> combinedFilters = new ArrayList<Beyond>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Beyond unrolled = ff.beyond(left, right, filter.getDistance(), filter.getDistanceUnits());
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Contains filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Contains> combinedFilters = new ArrayList<Contains>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Contains unrolled = ff.contains(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Crosses filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Crosses> combinedFilters = new ArrayList<Crosses>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Crosses unrolled = ff.crosses(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Disjoint filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Disjoint> combinedFilters = new ArrayList<Disjoint>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Disjoint unrolled = ff.disjoint(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(DWithin filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<DWithin> combinedFilters = new ArrayList<DWithin>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            DWithin unrolled = ff.dwithin(left, right, filter.getDistance(), filter.getDistanceUnits());
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Equals filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Equals> combinedFilters = new ArrayList<Equals>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Equals unrolled = ff.equal(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Intersects filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Intersects> combinedFilters = new ArrayList<Intersects>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Intersects unrolled = ff.intersects(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Overlaps filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Overlaps> combinedFilters = new ArrayList<Overlaps>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Overlaps unrolled = ff.overlaps(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Touches filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Touches> combinedFilters = new ArrayList<Touches>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Touches unrolled = ff.touches(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visit(Within filter, Object arg1) {
        Expression[][] exps = this.visitBinarySpatialOp((BinarySpatialOperator)filter);
        ArrayList<Within> combinedFilters = new ArrayList<Within>(exps.length);
        for (int i = 0; i < exps.length; ++i) {
            Expression left = exps[i][0];
            Expression right = exps[i][1];
            Within unrolled = ff.within(left, right);
            combinedFilters.add(unrolled);
        }
        Filter unrolled = this.combineOred(combinedFilters);
        return unrolled;
    }

    public Object visitNullFilter(Object arg0) {
        return Filter.EXCLUDE;
    }

    public Object visit(NilExpression expr, Object arg1) {
        return Collections.singletonList(expr);
    }

    public Object visit(Add expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Add> combinedExpressions = new ArrayList<Add>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            Add sourceExpression = ff.add(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }

    public Object visit(Divide expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Divide> combinedExpressions = new ArrayList<Divide>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            Divide sourceExpression = ff.divide(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }

    public Object visit(Function function, Object arg1) {
        List expressions = function.getParameters();
        ArrayList<Expression> arguments = new ArrayList<Expression>(expressions.size());
        for (Expression mappingExpression : expressions) {
            List sourceExpressions = (List)mappingExpression.accept((ExpressionVisitor)this, null);
            if (sourceExpressions.size() > 1) {
                throw new UnsupportedOperationException("unrolling function arguments that map to more than one source expressions is not supported yet");
            }
            Expression unrolledExpression = (Expression)sourceExpressions.get(0);
            arguments.add(unrolledExpression);
        }
        Expression[] unmapped = new Expression[arguments.size()];
        unmapped = arguments.toArray(unmapped);
        Function unmappedFunction = ff.function(function.getName(), unmapped);
        return Collections.singletonList(unmappedFunction);
    }

    public Object visit(Literal expr, Object arg1) {
        return Collections.singletonList(expr);
    }

    public Object visit(Multiply expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Multiply> combinedExpressions = new ArrayList<Multiply>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            Multiply sourceExpression = ff.multiply(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }

    public Object visit(PropertyName expr, Object arg1) {
        String targetXPath = expr.getPropertyName();
        NamespaceSupport namespaces = this.mappings.getNamespaces();
        AttributeDescriptor root = this.mappings.getTargetFeature();
        XPath.StepList simplifiedSteps = XPath.steps(root, targetXPath, namespaces);
        List<Expression> matchingMappings = this.findMappingsFor(this.mappings, simplifiedSteps);
        if (matchingMappings.isEmpty() && simplifiedSteps.size() > 1) {
            matchingMappings.add((Expression)new NestedAttributeExpression(targetXPath, this.mappings));
        }
        if (matchingMappings.size() == 0) {
            throw new IllegalArgumentException("Can't find source expression for: " + targetXPath);
        }
        return matchingMappings;
    }

    protected List<Expression> findMappingsFor(FeatureTypeMapping mappings, XPath.StepList propertyName) {
        List<AttributeMapping> candidates;
        if (!propertyName.toString().contains("[")) {
            candidates = mappings.getAttributeMappingsIgnoreIndex(propertyName);
        } else {
            candidates = new ArrayList<AttributeMapping>();
            AttributeMapping mapping = mappings.getAttributeMapping(propertyName);
            if (mapping != null) {
                candidates.add(mapping);
            }
        }
        List expressions = this.getExpressions(candidates);
        if (candidates.size() == 0 && propertyName.size() > 1) {
            FeatureTypeMapping inputMapping;
            XPath.Step clientPropertyStep = (XPath.Step)propertyName.get(propertyName.size() - 1);
            Name clientPropertyName = Types.toTypeName(clientPropertyStep.getName());
            XPath.StepList parentPath = new XPath.StepList(propertyName);
            parentPath.remove(parentPath.size() - 1);
            candidates = mappings.getAttributeMappingsIgnoreIndex(parentPath);
            expressions = this.getClientPropertyExpressions(candidates, clientPropertyName);
            if (expressions.isEmpty() && (inputMapping = mappings.getUnderlyingComplexMapping()) != null) {
                return this.getClientPropertyExpressions(inputMapping.getAttributeMappingsIgnoreIndex(parentPath), clientPropertyName);
            }
        }
        return expressions;
    }

    private List getClientPropertyExpressions(List attributeMappings, Name clientPropertyName) {
        ArrayList<Expression> clientPropertyExpressions = new ArrayList<Expression>(attributeMappings.size());
        for (AttributeMapping attMapping : attributeMappings) {
            Map<Name, Expression> clientProperties = attMapping.getClientProperties();
            if (!clientProperties.containsKey(clientPropertyName)) continue;
            Expression propertyExpression = clientProperties.get(clientPropertyName);
            clientPropertyExpressions.add(propertyExpression);
        }
        return clientPropertyExpressions;
    }

    private List getExpressions(List attributeMappings) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(attributeMappings.size());
        for (AttributeMapping mapping : attributeMappings) {
            Expression sourceExpression = mapping.getSourceExpression();
            expressions.add(sourceExpression);
        }
        return expressions;
    }

    public Object visit(Subtract expr, Object arg1) {
        Expression[][] expressions = this.visitBinaryExpression((BinaryExpression)expr);
        ArrayList<Subtract> combinedExpressions = new ArrayList<Subtract>(expressions.length);
        for (int i = 0; i < expressions.length; ++i) {
            Expression left = expressions[i][0];
            Expression right = expressions[i][1];
            Subtract sourceExpression = ff.subtract(left, right);
            combinedExpressions.add(sourceExpression);
        }
        return combinedExpressions;
    }
}

