/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.geotools.feature.Types;
import org.geotools.feature.xpath.AttributeNodePointer;
import org.geotools.resources.Utilities;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class AttributeNodeIterator
implements NodeIterator {
    AttributeNodePointer pointer;
    ComplexAttribute feature;
    List<Property> children;
    int position;

    public AttributeNodeIterator(AttributeNodePointer pointer) {
        this.pointer = pointer;
        this.feature = (ComplexAttribute)pointer.getImmediateNode();
        this.children = new ArrayList<Property>(this.feature.getValue());
        this.position = 1;
    }

    public AttributeNodeIterator(AttributeNodePointer pointer, NodeNameTest filter) {
        Name attName;
        this.pointer = pointer;
        this.feature = (ComplexAttribute)pointer.getImmediateNode();
        String localName = filter.getNodeName().getName();
        String nameSpace = filter.getNamespaceURI();
        AttributeDescriptor descriptor = this.feature.getDescriptor();
        Name name = attName = descriptor == null ? this.feature.getType().getName() : descriptor.getName();
        if (Utilities.equals((Object)nameSpace, (Object)attName.getNamespaceURI()) && Utilities.equals((Object)localName, (Object)attName.getLocalPart())) {
            this.children = Collections.singletonList(this.feature);
        } else {
            Name name2 = Types.typeName(nameSpace, localName);
            this.children = new ArrayList<Property>(this.feature.getProperties(name2));
        }
        this.position = this.children.size() > 0 ? 1 : 0;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position <= this.children.size();
    }

    public NodePointer getNodePointer() {
        Attribute attribute = (Attribute)this.children.get(this.position - 1);
        Name name = attribute.getDescriptor().getName();
        QName qname = new QName(name.getNamespaceURI(), name.getLocalPart());
        return new AttributeNodePointer(this.pointer, attribute, qname);
    }
}

