/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.awt.RenderingHints;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.XMLConfigDigester;
import org.geotools.data.complex.xml.XmlFeatureCollection;
import org.geotools.data.complex.xml.XmlFeatureSource;
import org.geotools.data.complex.xml.XmlResponse;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.Types;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GMLSchema;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.util.Converters;
import org.geotools.xs.XSSchema;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDataStoreTest
extends TestCase {
    private static final String MOCK_DS_PARAM_KEY = "DATA_FILE_DIRECTORY_PARAM_KEY";
    private static final SAXBuilder sax = new SAXBuilder();
    static final XmlDataStore MOCK_DATASTORE = new XmlDataStore();
    private static final String schemaBase = "/test-data/";
    private static final String GSMLNS = "http://www.cgi-iugs.org/xml/GeoSciML/2";
    private static final String GMLNS = "http://www.opengis.net/gml";
    private final int MAX_FEATURES = 5;
    private DataAccess mappingDataStore;
    private Name typeName;
    static FilterFactory ff;

    protected void setUp() throws Exception {
        super.setUp();
        this.setFilterFactory();
        this.buildXmlBackedDataAccess();
        this.typeName = Types.typeName((String)GSMLNS, (String)"GeologicUnit");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        DataAccessRegistry.unregisterAll();
    }

    public void testDataStoreCreated() throws Exception {
        XmlDataStoreTest.assertNotNull((Object)this.mappingDataStore);
        FeatureType mappedFeatureType = this.mappingDataStore.getSchema(this.typeName);
        XmlDataStoreTest.assertNotNull((Object)mappedFeatureType);
    }

    public void testFilterTranslation() throws Exception {
        PropertyIsEqualTo inputFilter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"Unit Name1233811724109 UC1233811724109 description name"));
        ArrayList<Integer> ls = new ArrayList<Integer>();
        ls.add(1);
        MOCK_DATASTORE.setValidElements(ls);
        FeatureCollection features = this.getFeatures(5, (Filter)inputFilter);
        int size = this.size((FeatureCollection<FeatureType, Feature>)features);
        XmlDataStoreTest.assertEquals((int)ls.size(), (int)size);
        Query query = MOCK_DATASTORE.getQuery();
        XmlDataStoreTest.assertEquals((int)5, (int)query.getMaxFeatures());
        String translatedFilter = query.getFilter().toString();
        XmlDataStoreTest.assertTrue((this.getExpectedFilter().equals(translatedFilter) || this.getReversedExpectedFilter().equals(translatedFilter) ? 1 : 0) != 0);
    }

    public void testFeatureCounting() throws Exception {
        PropertyIsEqualTo inputFilter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"Unit Name1233811724109 UC1233811724109 description name"));
        ArrayList<Integer> ls = new ArrayList<Integer>();
        ls.add(1);
        MOCK_DATASTORE.setValidElements(ls);
        FeatureCollection features = this.getFeatures(5, (Filter)inputFilter);
        int size = this.size((FeatureCollection<FeatureType, Feature>)features);
        XmlDataStoreTest.assertEquals((int)ls.size(), (int)size);
    }

    public void testNoElementsReturned() throws Exception {
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"Unit Name1233811724109 UC1233811724109 description name"));
        ArrayList<Integer> ls = new ArrayList<Integer>();
        MOCK_DATASTORE.setValidElements(ls);
        FeatureCollection features = this.getFeatures(5, (Filter)filter);
        int size = this.size((FeatureCollection<FeatureType, Feature>)features);
        XmlDataStoreTest.assertEquals((int)0, (int)size);
        ArrayList<Feature> results = new ArrayList<Feature>();
        FeatureIterator it = features.features();
        while (it.hasNext()) {
            results.add(it.next());
        }
        it.close();
        XmlDataStoreTest.assertEquals((int)ls.size(), (int)results.size());
    }

    public void testFeaturesCreatedCorrectly() throws Exception {
        NameImpl GeologicUnitName = new NameImpl(GSMLNS, "GeologicUnit");
        NameImpl GeologicUnitType = new NameImpl(GSMLNS, "GeologicUnitType");
        PropertyIsEqualTo filter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"Unit Name1233811724109 UC1233811724109 description name"));
        XmlDataStore ds = MOCK_DATASTORE;
        ds.setFileName("./src/test/resources/test-data/xmlDataStoreResponse.xml");
        String s = Filter.INCLUDE.toString();
        ArrayList<Integer> ls = new ArrayList<Integer>();
        ls.add(1);
        ls.add(2);
        MOCK_DATASTORE.setValidElements(ls);
        ArrayList<Feature> results = new ArrayList<Feature>();
        FeatureCollection features = this.getFeatures(5, (Filter)filter);
        FeatureIterator it = features.features();
        while (it.hasNext()) {
            results.add(it.next());
        }
        it.close();
        XmlDataStoreTest.assertEquals((int)ls.size(), (int)results.size());
        String[] ids = new String[]{"1679161021439131319", "1679161041155866313"};
        int i = 0;
        while (i < ls.size()) {
            Feature f = (Feature)results.get(i);
            XmlDataStoreTest.assertEquals((String)ids[i], (String)f.getIdentifier().getID());
            XmlDataStoreTest.assertEquals((Object)GeologicUnitName, (Object)f.getName());
            XmlDataStoreTest.assertEquals((Object)GeologicUnitType, (Object)f.getDescriptor().getType().getName());
            ++i;
        }
        Feature feature = (Feature)results.get(0);
        List<Attribute> attDescList = this.getAttributesForProperty(feature, "description");
        XmlDataStoreTest.assertEquals((int)1, (int)attDescList.size());
        Attribute at = attDescList.get(0);
        XmlDataStoreTest.assertEquals((String)"Test description 1", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertEquals((int)0, (int)at.getUserData().size());
        List<Attribute> attNameList = this.getAttributesForProperty(feature, "name");
        XmlDataStoreTest.assertEquals((int)2, (int)attNameList.size());
        at = attNameList.get(0);
        XmlDataStoreTest.assertEquals((String)"Unit Name1248396531312 UC1248396531312 description name", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertEquals((int)1, (int)((Map)at.getUserData().get(Attributes.class)).size());
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
        at = attNameList.get(1);
        XmlDataStoreTest.assertEquals((String)"urn:cgi:feature:GSV:1679161021439131319", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertTrue((at.getUserData() != null && ((Map)at.getUserData().get(Attributes.class)).size() == 1 ? 1 : 0) != 0);
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("codeSpace")));
        List<Attribute> attPurposeList = this.getAttributesForProperty(feature, "purpose");
        XmlDataStoreTest.assertEquals((int)1, (int)attPurposeList.size());
        at = attPurposeList.get(0);
        XmlDataStoreTest.assertEquals((String)"CONSTANT", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertEquals((int)0, (int)at.getUserData().size());
        List<Attribute> attGUTypeList = this.getAttributesForProperty(feature, "rank");
        XmlDataStoreTest.assertEquals((int)1, (int)attGUTypeList.size());
        at = attGUTypeList.get(0);
        XmlDataStoreTest.assertEquals((String)"", (String)this.getValueForAttribute(at));
        XmlDataStoreTest.assertEquals((int)1, (int)at.getUserData().size());
        XmlDataStoreTest.assertEquals((String)"urn:cgi:classifier:GSV:LithostratigraphicUnitRank:formation", (String)this.getUserDataForAttribute(at, (Name)new NameImpl("http://www.w3.org/1999/xlink", "href")));
        List<Attribute> attObMethList = this.getAttributesForProperty(feature, "observationMethod");
        XmlDataStoreTest.assertEquals((int)1, (int)attObMethList.size());
        at = attObMethList.get(0);
        XmlDataStoreTest.assertEquals(null, (Object)at.getIdentifier());
        XmlDataStoreTest.assertEquals((Object)new NameImpl(GSMLNS, "observationMethod"), (Object)at.getName());
        XmlDataStoreTest.assertEquals((Object)new NameImpl(GSMLNS, "CGI_TermValuePropertyType"), (Object)at.getDescriptor().getType().getName());
        ComplexAttributeImpl ob = this.getNestedComplexValueForAttribute(at);
        XmlDataStoreTest.assertEquals(null, (Object)ob.getIdentifier());
        XmlDataStoreTest.assertEquals((Object)new NameImpl(GSMLNS, "CGI_TermValue"), (Object)ob.getName());
        XmlDataStoreTest.assertEquals((Object)new NameImpl(GSMLNS, "CGI_TermValueType"), (Object)ob.getDescriptor().getType().getName());
        ComplexAttributeImpl ob2 = this.getNestedComplexValueForAttribute((Attribute)ob);
        XmlDataStoreTest.assertEquals(null, (Object)ob2.getIdentifier());
        XmlDataStoreTest.assertEquals((Object)new NameImpl(GSMLNS, "value"), (Object)ob2.getName());
        XmlDataStoreTest.assertEquals((Object)new NameImpl(GSMLNS, "ScopedNameType"), (Object)ob2.getDescriptor().getType().getName());
        XmlDataStoreTest.assertEquals((String)"CONSTANT", (String)this.getValueForAttribute((Attribute)ob2));
        XmlDataStoreTest.assertEquals((String)"gsv:NameSpace", (String)this.getUserDataForAttribute((Attribute)ob2, (Name)new NameImpl("codeSpace")));
    }

    private String getValueForAttribute(Attribute sv) {
        Object value;
        if (sv instanceof ComplexAttribute && (value = GML3EncodingUtils.getSimpleContent((ComplexAttribute)((ComplexAttribute)sv))) != null) {
            return (String)Converters.convert((Object)value, String.class);
        }
        value = null;
        Object ob = sv.getValue();
        if (ob instanceof String) {
            value = (String)ob;
        } else {
            List values = (List)ob;
            if (values != null && values.size() > 0) {
                value = values.get(0).toString();
            }
        }
        return value;
    }

    private ComplexAttributeImpl getNestedComplexValueForAttribute(Attribute sv) {
        Object value = null;
        Object ob = sv.getValue();
        List values = (List)ob;
        if (values != null && values.size() > 0) {
            value = values.get(0);
        }
        return value;
    }

    private String getUserDataForAttribute(Attribute sv, Name key) {
        String value = null;
        Map userData = sv.getUserData();
        if (userData.containsKey(Attributes.class)) {
            Map map = (Map)userData.get(Attributes.class);
            value = (String)map.get(key);
        }
        return value;
    }

    private List<Attribute> getAttributesForProperty(Feature feature, String propertyName) {
        ArrayList<Attribute> returnValues = new ArrayList<Attribute>();
        Collection cs = feature.getProperties(propertyName);
        for (Attribute sv : cs) {
            returnValues.add(sv);
        }
        return returnValues;
    }

    private DefaultQuery namedQuery(Filter filter, int count) throws Exception {
        return new DefaultQuery("GeologicUnit", new URI(GSMLNS), filter, count, new String[0], "test");
    }

    private void setFilterFactory() {
        NamespaceSupport namespaces = new NamespaceSupport();
        namespaces.declarePrefix("gsml", GSMLNS);
        namespaces.declarePrefix("gml", GMLNS);
        ff = new FilterFactoryImplNamespaceAware(namespaces);
    }

    private void buildXmlBackedDataAccess() throws IOException {
        URL url = ((Object)((Object)this)).getClass().getResource("/test-data/xmlDataAccessConfig.xml");
        XmlDataStoreTest.assertNotNull((Object)url);
        AppSchemaDataAccessDTO config = new XMLConfigDigester().parse(url);
        Set mappings = AppSchemaDataAccessConfigurator.buildMappings((AppSchemaDataAccessDTO)config);
        this.mappingDataStore = new AppSchemaDataAccess(mappings);
    }

    private String getExpectedFilter() {
        String prefix = "/soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/";
        return "[[ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:formattedName = Unit Name1233811724109 UC1233811724109 description name ] OR [ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:urn[@domain='GSV'] = Unit Name1233811724109 UC1233811724109 description name ]]";
    }

    private String getReversedExpectedFilter() {
        String prefix = "/soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/";
        return "[[ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:urn[@domain='GSV'] = Unit Name1233811724109 UC1233811724109 description name ] OR [ /soapenv:Envelope/soapenv:Body/qaz:getGeologicalFeaturesByFilterStringResponse/qaz:out/qaz:item/gss:formattedName = Unit Name1233811724109 UC1233811724109 description name ]]";
    }

    private FeatureCollection getFeatures(int maxFeatures, Filter inputFilter) throws Exception {
        FeatureSource fSource = this.mappingDataStore.getFeatureSource(this.typeName);
        FeatureCollection features = fSource.getFeatures((Query)this.namedQuery(inputFilter, new Integer(maxFeatures)));
        return features;
    }

    private int size(FeatureCollection<FeatureType, Feature> features) {
        int size = 0;
        Iterator i = features.iterator();
        while (i.hasNext()) {
            ++size;
            i.next();
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockXmlDataStoreFactory
    implements DataStoreFactorySpi {
        public boolean isAvailable() {
            return true;
        }

        public boolean canProcess(Map<String, Serializable> params) {
            return params.get(XmlDataStoreTest.MOCK_DS_PARAM_KEY) != null;
        }

        public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
            XmlDataStore ds = MOCK_DATASTORE;
            ds.setFileName((String)((Object)params.get(XmlDataStoreTest.MOCK_DS_PARAM_KEY)));
            return ds;
        }

        public DataStore createNewDataStore(Map params) throws IOException {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public DataAccessFactory.Param[] getParametersInfo() {
            return null;
        }

        public Map<RenderingHints.Key, ?> getImplementationHints() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class XmlDataStore
    implements DataStore {
        private String fileName;
        private List<Integer> validElements;
        private Query query;

        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
            return null;
        }

        public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
            return null;
        }

        public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
            return null;
        }

        public LockingManager getLockingManager() {
            return null;
        }

        public SimpleFeatureType getSchema(String typeName) throws IOException {
            return null;
        }

        public String[] getTypeNames() throws IOException {
            return null;
        }

        public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        }

        public void createSchema(SimpleFeatureType featureType) throws IOException {
        }

        public void dispose() {
        }

        public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
            return new XmlTestFeatureSource(this);
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setValidElements(List<Integer> validElements) {
            this.validElements = validElements;
        }

        public Query getQuery() {
            return this.query;
        }

        public int getCount(Query query) {
            return -1;
        }

        public ServiceInfo getInfo() {
            return null;
        }

        public List<Name> getNames() throws IOException {
            return null;
        }

        public SimpleFeatureType getSchema(Name name) throws IOException {
            return null;
        }

        public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        }

        public XmlResponse getXmlReader(Query query, Transaction transaction) throws IOException {
            this.query = query;
            Document doc = null;
            try {
                File outFile = new File(this.fileName);
                DataInputStream dos = new DataInputStream(new FileInputStream(outFile));
                doc = sax.build((InputStream)dos);
            }
            catch (JDOMException e1) {
                throw new RuntimeException("error reading xml from file ", e1);
            }
            return new XmlResponse(doc, this.validElements);
        }
    }

    public static final class XmlTestFeatureCollection
    extends DataFeatureCollection
    implements XmlFeatureCollection {
        private Query query;
        private XmlDataStore dataStore;
        private XmlResponse xmlResponse;

        public XmlTestFeatureCollection(XmlDataStore dataStore, Query query) throws IOException {
            this.dataStore = dataStore;
            this.query = query;
        }

        public ReferencedEnvelope getBounds() {
            throw new UnsupportedOperationException("No bounds for WS!");
        }

        public int getCount() throws IOException {
            return this.dataStore.getCount(this.query);
        }

        public XmlResponse xmlResponse() {
            try {
                this.xmlResponse = this.dataStore.getXmlReader(this.query, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.xmlResponse;
        }
    }

    public static final class XmlTestFeatureSource
    implements XmlFeatureSource {
        private XmlDataStore dataStore;

        public XmlTestFeatureSource(DataStore dataStore) throws IOException {
            this.dataStore = (XmlDataStore)dataStore;
        }

        public Name getName() {
            return new NameImpl(XmlDataStoreTest.GSMLNS, "GeologicUnit");
        }

        public DataStore getDataStore() {
            return this.dataStore;
        }

        public SimpleFeatureType getSchema() {
            ArrayList<AttributeDescriptorImpl> schema = new ArrayList<AttributeDescriptorImpl>();
            schema.add(new AttributeDescriptorImpl(XSSchema.DOUBLE_TYPE, Types.typeName((String)"pointOne"), 0, 1, false, null));
            schema.add(new AttributeDescriptorImpl(XSSchema.DOUBLE_TYPE, Types.typeName((String)"pointTwo"), 0, 1, false, null));
            return new SimpleFeatureTypeImpl(Types.typeName((String)"GeometryContainer"), schema, null, false, null, (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
        }

        public void setNamespaces(NamespaceSupport namespaces) {
        }

        public void setItemXpath(String inputAttributeXpathPrefix) {
        }

        public ResourceInfo getInfo() {
            return null;
        }

        public void addFeatureListener(FeatureListener listener) {
        }

        public void removeFeatureListener(FeatureListener listener) {
        }

        public ReferencedEnvelope getBounds() throws IOException {
            return this.getInfo().getBounds();
        }

        public ReferencedEnvelope getBounds(Query query) throws IOException {
            return null;
        }

        public int getCount(Query query) throws IOException {
            Query namedQuery = this.namedQuery(query);
            return this.dataStore.getCount(namedQuery);
        }

        public XmlTestFeatureCollection getFeatures(Filter filter) throws IOException {
            return this.getFeatures((Query)new DefaultQuery("GeologicUnit", filter));
        }

        public XmlTestFeatureCollection getFeatures() throws IOException {
            return this.getFeatures((Query)new DefaultQuery("GeologicUnit"));
        }

        public XmlTestFeatureCollection getFeatures(Query query) throws IOException {
            return new XmlTestFeatureCollection(this.dataStore, this.namedQuery(query));
        }

        public Set getSupportedHints() {
            return Collections.EMPTY_SET;
        }

        private Query namedQuery(Query query) {
            return new DefaultQuery(query);
        }

        public QueryCapabilities getQueryCapabilities() {
            return null;
        }
    }
}

