/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.DataAccess;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingFeatureSource
implements FeatureSource<FeatureType, Feature> {
    private AppSchemaDataAccess store;
    private FeatureTypeMapping mapping;

    public MappingFeatureSource(AppSchemaDataAccess store, FeatureTypeMapping mapping) {
        this.store = store;
        this.mapping = mapping;
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException();
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.store.getBounds((Query)this.namedQuery((Filter)Filter.INCLUDE, Integer.MAX_VALUE));
    }

    private DefaultQuery namedQuery(Filter filter, int countLimit) {
        DefaultQuery query = new DefaultQuery();
        if (this.getName().getNamespaceURI() != null) {
            try {
                query.setNamespace(new URI(this.getName().getNamespaceURI()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        query.setTypeName(this.getName().getLocalPart());
        query.setFilter(filter);
        query.setMaxFeatures(countLimit);
        return query;
    }

    private DefaultQuery namedQuery(Query query) {
        DefaultQuery namedQuery = this.namedQuery(query.getFilter(), query.getMaxFeatures());
        namedQuery.setPropertyNames(query.getPropertyNames());
        namedQuery.setCoordinateSystem(query.getCoordinateSystem());
        namedQuery.setCoordinateSystemReproject(query.getCoordinateSystemReproject());
        namedQuery.setHandle(query.getHandle());
        namedQuery.setMaxFeatures(query.getMaxFeatures());
        namedQuery.setSortBy(query.getSortBy());
        return namedQuery;
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        DefaultQuery namedQuery = this.namedQuery(query);
        return this.store.getBounds((Query)namedQuery);
    }

    public int getCount(Query query) throws IOException {
        DefaultQuery namedQuery = this.namedQuery(query);
        int count = this.store.getCount((Query)namedQuery);
        if (count >= 0) {
            return count;
        }
        int featureCount = 0;
        FeatureIterator features = null;
        try {
            features = this.getFeatures((Query)namedQuery).features();
            while (features.hasNext()) {
                ++featureCount;
                features.next();
            }
        }
        finally {
            if (features != null) {
                features.close();
            }
        }
        return featureCount;
    }

    public DataAccess<FeatureType, Feature> getDataStore() {
        return this.store;
    }

    public FeatureType getSchema() {
        return (FeatureType)this.mapping.getTargetFeature().getType();
    }

    public AttributeDescriptor getTargetFeature() {
        return this.mapping.getTargetFeature();
    }

    protected FeatureTypeMapping getMapping() {
        return this.mapping;
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
        return new MappingFeatureCollection(this.store, this.mapping, (Query)this.namedQuery(query));
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
        return new MappingFeatureCollection(this.store, this.mapping, (Query)this.namedQuery(filter, Integer.MAX_VALUE));
    }

    public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
        return new MappingFeatureCollection(this.store, this.mapping, (Query)this.namedQuery((Filter)Filter.INCLUDE, Integer.MAX_VALUE));
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException("this is a read only feature source");
    }

    public ResourceInfo getInfo() {
        throw new UnsupportedOperationException();
    }

    public Name getName() {
        Name name = this.mapping.getTargetFeature().getName();
        return name;
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return Collections.emptySet();
    }

    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities();
    }
}

