/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.AppSchemaCatalog;
import org.geotools.xml.AppSchemaConfiguration;
import org.geotools.xml.AppSchemaResolver;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class EmfAppSchemaReader {
    private AppSchemaResolver resolver = new AppSchemaResolver();

    private EmfAppSchemaReader() {
    }

    public AppSchemaResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(AppSchemaResolver resolver) {
        this.resolver = resolver;
    }

    public void setResolver(URL catalogLocation) {
        this.resolver = new AppSchemaResolver(AppSchemaCatalog.build((URL)catalogLocation));
    }

    public SchemaIndex parse(Configuration configuration) throws IOException {
        SchemaIndex appSchemaIndex = Schemas.findSchemas((Configuration)configuration);
        return appSchemaIndex;
    }

    public SchemaIndex parse(String nameSpace, String schemaLocation) throws IOException {
        AppSchemaConfiguration configuration = new AppSchemaConfiguration(nameSpace, schemaLocation, this.resolver, new Configuration[]{new GMLConfiguration()});
        return this.parse((Configuration)configuration);
    }

    public SchemaIndex parse(URL location) throws IOException {
        String nameSpace = this.findSchemaNamespace(location);
        String schemaLocation = location.toExternalForm();
        return this.parse(nameSpace, schemaLocation);
    }

    public String findSchemaNamespace(URL location) throws IOException {
        String targetNamespace = null;
        URL resolvedLocation = new URL(this.resolver.resolve(location.toExternalForm()));
        InputStream input = resolvedLocation.openStream();
        XmlPullParser parser = null;
        try {
            try {
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                parser = factory.newPullParser();
                parser.setInput(input, "UTF-8");
                parser.nextTag();
                int i = 0;
                while (i < parser.getAttributeCount()) {
                    if ("targetNamespace".equals(parser.getAttributeName(i))) {
                        targetNamespace = parser.getAttributeValue(i);
                        break;
                    }
                    ++i;
                }
                parser.setInput(null);
            }
            catch (XmlPullParserException e) {
                String msg = "Cannot find target namespace for schema document " + resolvedLocation;
                throw (RuntimeException)new RuntimeException(msg).initCause(e);
            }
        }
        finally {
            input.close();
        }
        if (targetNamespace == null) {
            throw new IllegalArgumentException("Input document does not specifies a targetNamespace");
        }
        return targetNamespace;
    }

    public static EmfAppSchemaReader newInstance() {
        return new EmfAppSchemaReader();
    }
}

