/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Enumeration;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.feature.type.UniqueNameFeatureTypeImpl;
import org.geotools.feature.xpath.AttributeDescriptorPropertyHandler;
import org.geotools.feature.xpath.AttributeNodePointerFactory;
import org.geotools.feature.xpath.AttributePropertyHandler;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.xml.sax.helpers.NamespaceSupport;

public class FeaturePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor ATTRIBUTE_ACCESS;
    static PropertyAccessor DEFAULT_GEOMETRY_ACCESS;
    static PropertyAccessor FID_ACCESS;

    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new AttributeNodePointerFactory());
        ATTRIBUTE_ACCESS = new FeaturePropertyAccessor();
        DEFAULT_GEOMETRY_ACCESS = new DefaultGeometryFeaturePropertyAccessor();
        FID_ACCESS = new FidFeaturePropertyAccessor();
    }

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (SimpleFeature.class.isAssignableFrom(type)) {
            return null;
        }
        if (xpath == null) {
            return null;
        }
        if (!(ComplexAttribute.class.isAssignableFrom(type) || ComplexType.class.isAssignableFrom(type) || AttributeDescriptor.class.isAssignableFrom(type))) {
            return null;
        }
        if ("".equals(xpath)) {
            return DEFAULT_GEOMETRY_ACCESS;
        }
        if (xpath.matches("@(\\w+:)?id")) {
            return FID_ACCESS;
        }
        NamespaceSupport namespaces = null;
        if (hints != null) {
            namespaces = (NamespaceSupport)hints.get((Object)NAMESPACE_CONTEXT);
        }
        if (namespaces == null) {
            return ATTRIBUTE_ACCESS;
        }
        return new FeaturePropertyAccessor(namespaces);
    }

    static String stripPrefix(String xpath) {
        int split = xpath.indexOf(":");
        if (split != -1) {
            return xpath.substring(split + 1);
        }
        return xpath;
    }

    static class DefaultGeometryFeaturePropertyAccessor
    implements PropertyAccessor {
        DefaultGeometryFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            if (!"".equals(xpath)) {
                return false;
            }
            return object instanceof Feature || object instanceof FeatureType;
        }

        public Object get(Object object, String xpath, Class target) {
            if (object instanceof Feature) {
                return ((Feature)object).getDefaultGeometryProperty();
            }
            if (object instanceof FeatureType) {
                FeatureType ft = (FeatureType)object;
                GeometryDescriptor gd = ft.getGeometryDescriptor();
                if (gd == null) {
                    for (PropertyDescriptor pd : ft.getDescriptors()) {
                        if (!Geometry.class.isAssignableFrom(pd.getType().getBinding())) continue;
                        return pd;
                    }
                }
                return gd;
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            if (object instanceof Feature) {
                Feature f = (Feature)object;
                if (value instanceof GeometryAttribute) {
                    GeometryAttribute geom = (GeometryAttribute)value;
                    f.setDefaultGeometryProperty(geom);
                } else if (value instanceof Geometry) {
                    GeometryAttribute geom = f.getDefaultGeometryProperty();
                    geom.setValue(value);
                } else {
                    throw new IllegalArgumentException("Argument is not a geometry: " + value);
                }
            }
            if (object instanceof FeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
        }
    }

    static class FeaturePropertyAccessor
    implements PropertyAccessor {
        private NamespaceSupport namespaces;

        static {
            JXPathIntrospector.registerDynamicClass(FeatureImpl.class, AttributePropertyHandler.class);
            JXPathIntrospector.registerDynamicClass(SimpleFeatureImpl.class, AttributePropertyHandler.class);
            JXPathIntrospector.registerDynamicClass(ComplexAttributeImpl.class, AttributePropertyHandler.class);
            JXPathIntrospector.registerDynamicClass(AttributeImpl.class, AttributePropertyHandler.class);
            JXPathIntrospector.registerDynamicClass(GeometryAttributeImpl.class, AttributePropertyHandler.class);
            JXPathIntrospector.registerDynamicClass(AttributeDescriptorImpl.class, AttributeDescriptorPropertyHandler.class);
            JXPathIntrospector.registerDynamicClass(FeatureTypeImpl.class, AttributeDescriptorPropertyHandler.class);
            JXPathIntrospector.registerDynamicClass(UniqueNameFeatureTypeImpl.class, AttributeDescriptorPropertyHandler.class);
        }

        public FeaturePropertyAccessor() {
            this.namespaces = new NamespaceSupport();
        }

        public FeaturePropertyAccessor(NamespaceSupport namespaces) {
            this.namespaces = namespaces;
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof Attribute || object instanceof AttributeType || object instanceof AttributeDescriptor;
        }

        public Object get(Object object, String xpath, Class target) {
            JXPathContext context = JXPathContext.newContext((Object)object);
            Enumeration<String> declaredPrefixes = this.namespaces.getDeclaredPrefixes();
            while (declaredPrefixes.hasMoreElements()) {
                String prefix = declaredPrefixes.nextElement();
                String uri = this.namespaces.getURI(prefix);
                context.registerNamespace(prefix, uri);
            }
            Object value = context.getValue(xpath);
            return value;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            if (object instanceof FeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
            JXPathContext context = JXPathContext.newContext((Object)object);
            context.setValue(xpath, value);
            assert (value == context.getValue(xpath));
        }
    }

    static class FidFeaturePropertyAccessor
    implements PropertyAccessor {
        FidFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof Attribute && xpath.matches("@(\\w+:)?id");
        }

        public Object get(Object object, String xpath, Class target) {
            Attribute feature = (Attribute)object;
            return feature.getIdentifier().toString();
        }

        public void set(Object object, String xpath, Object value, Class target) {
            throw new org.opengis.feature.IllegalAttributeException(null, value, "feature id is immutable");
        }
    }
}

