/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.filter.XPath;
import org.geotools.feature.AppSchemaFeatureFactoryImpl;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.util.logging.Logging;
import org.geotools.xlink.XLINK;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingFeatureIterator
implements IMappingFeatureIterator {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.complex");
    public static final Name XLINK_HREF_NAME = Types.toTypeName(XLINK.HREF);
    protected FeatureTypeMapping mapping;
    protected FeatureFactory attf;
    protected AppSchemaDataAccess store;
    protected final XPath xpathAttributeBuilder;
    protected FilterFactory namespaceAwareFilterFactory;
    protected final int maxFeatures;
    protected int featureCounter;
    protected NamespaceSupport namespaces;
    private boolean hasNextCalled = false;
    protected Set<String> propertyNames;

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        this(store, mapping, query, false);
    }

    public AbstractMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query, boolean isQueryUnrolled) throws IOException {
        this.store = store;
        this.attf = new AppSchemaFeatureFactoryImpl();
        Name name = mapping.getTargetFeature().getName();
        this.propertyNames = query.getPropertyNames() == null ? null : new HashSet<String>(Arrays.asList(query.getPropertyNames()));
        this.mapping = mapping;
        this.maxFeatures = query.getMaxFeatures();
        if (!isQueryUnrolled) {
            query = this.getUnrolledQuery(query);
        }
        this.xpathAttributeBuilder = new XPath();
        this.xpathAttributeBuilder.setFeatureFactory(this.attf);
        this.initialiseSourceFeatures(mapping, query);
        this.namespaces = mapping.getNamespaces();
        this.namespaceAwareFilterFactory = new FilterFactoryImplNamespaceAware(this.namespaces);
        this.xpathAttributeBuilder.setFilterFactory(this.namespaceAwareFilterFactory);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.closeSourceFeatures();
    }

    protected abstract String extractIdForAttribute(Expression var1, Object var2);

    @Override
    public Feature next() {
        Feature next;
        if (!this.isHasNextCalled()) {
            LOGGER.warning("hasNext not called before calling next() in the iterator!");
            if (!this.hasNext()) {
                return null;
            }
        }
        try {
            next = this.computeNext();
        }
        catch (IOException e) {
            this.close();
            throw new RuntimeException(e);
        }
        ++this.featureCounter;
        return next;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextCalled) {
            return !this.isNextSourceFeatureNull();
        }
        boolean exists = false;
        if (this.featureCounter >= this.maxFeatures) {
            return false;
        }
        if (this.isSourceFeatureIteratorNull()) {
            return false;
        }
        exists = this.unprocessedFeatureExists();
        if (!exists) {
            LOGGER.finest("no more features, produced " + this.featureCounter);
            this.close();
        }
        this.setHasNextCalled(true);
        return exists;
    }

    protected Query getUnrolledQuery(Query query) {
        return this.store.unrollQuery(query, this.mapping);
    }

    protected Feature computeNext() throws IOException {
        if (!this.hasNextCalled && !this.hasNext()) {
            return null;
        }
        this.hasNextCalled = false;
        if (this.isNextSourceFeatureNull()) {
            throw new UnsupportedOperationException("No more features produced!");
        }
        String id = this.extractIdForFeature();
        return this.populateFeatureData(id);
    }

    protected boolean isHasNextCalled() {
        return this.hasNextCalled;
    }

    protected void setHasNextCalled(boolean hasNextCalled) {
        this.hasNextCalled = hasNextCalled;
    }

    protected abstract void closeSourceFeatures();

    protected abstract Iterator<Feature> getSourceFeatureIterator();

    protected abstract void initialiseSourceFeatures(FeatureTypeMapping var1, Query var2) throws IOException;

    protected abstract boolean unprocessedFeatureExists();

    protected abstract boolean sourceFeatureIteratorHasNext();

    protected abstract String extractIdForFeature();

    protected abstract boolean isNextSourceFeatureNull();

    protected abstract Feature populateFeatureData(String var1) throws IOException;

    protected abstract Object getValue(Expression var1, Object var2);

    protected abstract boolean isSourceFeatureIteratorNull();

    protected abstract void setClientProperties(Attribute var1, Object var2, Map<Name, Expression> var3);
}

