/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.FilteringMappingFeatureIterator;
import org.geotools.data.complex.IMappingFeatureIterator;
import org.geotools.data.complex.XmlFeatureTypeMapping;
import org.geotools.data.complex.XmlMappingFeatureIterator;
import org.geotools.data.complex.filter.MultiValuedOrImpl;
import org.geotools.filter.FidFilterImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;

public class MappingFeatureIteratorFactory {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.complex");

    public static IMappingFeatureIterator getInstance(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        if (mapping instanceof XmlFeatureTypeMapping) {
            return new XmlMappingFeatureIterator(store, mapping, query);
        }
        boolean isFiltered = false;
        if (query.getFilter() != null) {
            Query unrolledQuery = store.unrollQuery(query, mapping);
            Filter filter = unrolledQuery.getFilter();
            if (filter instanceof MultiValuedOrImpl) {
                unrolledQuery.setFilter((Filter)Filter.INCLUDE);
                return new FilteringMappingFeatureIterator(store, mapping, unrolledQuery, filter);
            }
            if (!(filter.equals(Filter.INCLUDE) || filter.equals(Filter.EXCLUDE) || filter instanceof FidFilterImpl)) {
                isFiltered = true;
            }
        }
        DataAccessMappingFeatureIterator iterator = null;
        try {
            iterator = new DataAccessMappingFeatureIterator(store, mapping, query, isFiltered);
        }
        catch (IOException e) {
            if (isFiltered) {
                LOGGER.info("Caught exception: " + e.getMessage() + "in DataAccessMappingFeatureIterator." + "Assuming this is caused by filtering nested attribute." + "Retrying with FilteringMappingFeatureIterator.");
                Query unrolledQuery = store.unrollQuery(query, mapping);
                Filter filter = unrolledQuery.getFilter();
                unrolledQuery.setFilter((Filter)Filter.INCLUDE);
                iterator = new FilteringMappingFeatureIterator(store, mapping, unrolledQuery, filter);
            }
            throw e;
        }
        return iterator;
    }
}

