/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAttributeMapping
extends AttributeMapping {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.complex");
    private FeatureSource<FeatureType, Feature> source;
    private FeatureSource<FeatureType, Feature> mappingSource;
    private final Expression nestedFeatureType;
    private final XPath.StepList nestedTargetXPath;
    private Expression nestedSourceExpression;
    private FilterFactory filterFac;
    private NamespaceSupport namespaces;
    private Expression nestedIdExpression;

    public NestedAttributeMapping(Expression idExpression, Expression parentExpression, XPath.StepList targetXPath, boolean isMultiValued, Map<Name, Expression> clientProperties, Expression sourceElement, XPath.StepList sourcePath, NamespaceSupport namespaces) throws IOException {
        super(idExpression, parentExpression, targetXPath, null, isMultiValued, clientProperties);
        this.nestedTargetXPath = sourcePath;
        this.nestedFeatureType = sourceElement;
        this.filterFac = new FilterFactoryImplNamespaceAware(namespaces);
        this.namespaces = namespaces;
    }

    @Override
    public boolean isNestedAttribute() {
        return true;
    }

    public List<Feature> getInputFeatures(Object foreignKeyValue, Feature feature) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        if (this.source == null || !(this.nestedFeatureType instanceof AttributeExpressionImpl)) {
            Object featureTypeName = this.getNestedFeatureType(feature);
            if (featureTypeName == null || !(featureTypeName instanceof Name)) {
                return Collections.EMPTY_LIST;
            }
            FeatureTypeMapping featureTypeMapping = AppSchemaDataAccessRegistry.getMappingByName((Name)featureTypeName);
            if (featureTypeMapping == null) {
                LOGGER.info("FeatureTypeMapping for '" + featureTypeName + "' not found when evaluating filter!");
                return Collections.EMPTY_LIST;
            }
            this.nestedIdExpression = featureTypeMapping.getFeatureIdExpression();
            this.source = featureTypeMapping.getSource();
            if (this.source == null) {
                LOGGER.info("Feature source for '" + featureTypeName + "' not found when evaluating filter");
                return Collections.EMPTY_LIST;
            }
            List<AttributeMapping> mappings = featureTypeMapping.getAttributeMappingsIgnoreIndex(this.nestedTargetXPath);
            if (mappings.size() < 1) {
                throw new IllegalArgumentException("Mapping is missing for: '" + (Object)((Object)this.nestedTargetXPath) + "'!");
            }
            this.nestedSourceExpression = mappings.get(0).getSourceExpression();
        }
        return this.getFilteredFeatures(foreignKeyValue);
    }

    private List<Feature> getFilteredFeatures(Object foreignKeyValue) throws IOException {
        Feature f;
        HashSet<Object> featureIds;
        if (this.nestedSourceExpression == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        PropertyIsEqualTo filter = this.filterFac.equals(this.nestedSourceExpression, (Expression)this.filterFac.literal(foreignKeyValue));
        FeatureCollection fCollection = this.source.getFeatures((Filter)filter);
        FeatureIterator it = fCollection.features();
        Id matchingIdFilter = null;
        if (this.nestedIdExpression.equals(Expression.NIL)) {
            featureIds = new HashSet<Object>();
            while (it.hasNext()) {
                f = it.next();
                matchingFeatures.add(f);
                if (f.getIdentifier() == null) continue;
                featureIds.add(f.getIdentifier());
            }
            if (!featureIds.isEmpty()) {
                matchingIdFilter = this.filterFac.id(featureIds);
            }
        } else {
            featureIds = new HashSet();
            while (it.hasNext()) {
                f = it.next();
                matchingFeatures.add(f);
                featureIds.add(Converters.convert((Object)this.nestedIdExpression.evaluate((Object)f), String.class));
            }
            if (!featureIds.isEmpty()) {
                ArrayList<PropertyIsEqualTo> idFilters = new ArrayList<PropertyIsEqualTo>(featureIds.size());
                for (String string : featureIds) {
                    idFilters.add(this.filterFac.equals(this.nestedIdExpression, (Expression)this.filterFac.literal((Object)string)));
                }
                matchingIdFilter = this.filterFac.or(idFilters);
            }
        }
        it.close();
        if (matchingIdFilter != null && (fCollection = this.source.getFeatures((Filter)matchingIdFilter)).size() > matchingFeatures.size()) {
            it = fCollection.features();
            matchingFeatures.clear();
            while (it.hasNext()) {
                matchingFeatures.add(it.next());
            }
            it.close();
        }
        return matchingFeatures;
    }

    public List<Feature> getInputFeatures(Object foreignKeyValue, FeatureTypeMapping fMapping) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        if (this.source == null || !(this.nestedFeatureType instanceof AttributeExpressionImpl)) {
            assert (fMapping != null);
            this.source = fMapping.getSource();
            if (this.source == null) {
                LOGGER.info("Feature source for '" + fMapping.getTargetFeature().getName() + "' not found when evaluating filter");
                return Collections.EMPTY_LIST;
            }
            this.nestedIdExpression = fMapping.getFeatureIdExpression();
            List<AttributeMapping> mappings = fMapping.getAttributeMappingsIgnoreIndex(this.nestedTargetXPath);
            if (mappings.size() < 1) {
                throw new IllegalArgumentException("Mapping is missing for: '" + (Object)((Object)this.nestedTargetXPath) + "'!");
            }
            this.nestedSourceExpression = mappings.get(0).getSourceExpression();
        }
        return this.getFilteredFeatures(foreignKeyValue);
    }

    public List<Feature> getFeatures(Object foreignKeyValue, CoordinateReferenceSystem reprojection, Feature feature) throws IOException {
        if (this.isSameSource()) {
            throw new UnsupportedOperationException("Link field is missing from feature chaining mapping!");
        }
        FeatureSource<FeatureType, Feature> fSource = this.getMappingSource(feature);
        if (fSource == null) {
            return null;
        }
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        PropertyName propertyName = this.filterFac.property(this.nestedTargetXPath.toString());
        PropertyIsEqualTo filter = this.filterFac.equals((Expression)propertyName, (Expression)this.filterFac.literal(foreignKeyValue));
        Query query = new Query();
        query.setCoordinateSystemReproject(reprojection);
        query.setFilter((Filter)filter);
        FeatureCollection fCollection = fSource.getFeatures(query);
        FeatureIterator iterator = fCollection.features();
        while (iterator.hasNext()) {
            matchingFeatures.add(iterator.next());
        }
        iterator.close();
        return matchingFeatures;
    }

    private FeatureSource<FeatureType, Feature> getMappingSource(Feature feature) throws IOException {
        if (this.mappingSource == null || !(this.nestedFeatureType instanceof AttributeExpressionImpl)) {
            Object featureTypeName = this.getNestedFeatureType(feature);
            if (featureTypeName == null || !(featureTypeName instanceof Name)) {
                return null;
            }
            this.mappingSource = DataAccessRegistry.getFeatureSource((Name)featureTypeName);
        }
        return this.mappingSource;
    }

    public Object getNestedFeatureType(Feature feature) {
        Object fTypeValue = this.nestedFeatureType instanceof AttributeExpressionImpl ? ((AttributeExpressionImpl)this.nestedFeatureType).getPropertyName() : this.nestedFeatureType.evaluate((Object)feature);
        if (fTypeValue == null) {
            return null;
        }
        if (!(fTypeValue instanceof Hints)) {
            return Types.degloseName(fTypeValue.toString(), this.namespaces);
        }
        return fTypeValue;
    }

    public boolean isSameSource() {
        return this.nestedTargetXPath == null;
    }

    public boolean isConditional() {
        return !(this.nestedFeatureType instanceof AttributeExpressionImpl);
    }

    public FeatureTypeMapping getFeatureTypeMapping(Feature feature) throws IOException {
        FeatureSource<FeatureType, Feature> fSource = this.getMappingSource(feature);
        if (fSource == null) {
            return null;
        }
        return fSource instanceof MappingFeatureSource ? ((MappingFeatureSource)fSource).getMapping() : null;
    }

    public NamespaceSupport getNamespaces() {
        return this.namespaces;
    }
}

