/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.filter;

import java.util.List;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.NestedAttributeExpression;
import org.geotools.filter.OrImpl;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class MultiValuedOrImpl
extends OrImpl {
    private Filter filter;
    private NestedAttributeExpression expression;

    public MultiValuedOrImpl(FilterFactory ff, Filter filter, NestedAttributeExpression expression) {
        super(ff, null);
        this.filter = filter;
        this.expression = expression;
    }

    public boolean evaluate(Object feature) {
        Object value = this.expression.evaluate(feature);
        if (value != null) {
            List values = (List)value;
            if (this.filter instanceof BinaryComparisonAbstract) {
                BinaryComparisonAbstract compFilter = (BinaryComparisonAbstract)this.filter;
                Expression exp1 = compFilter.getExpression1();
                Expression exp2 = compFilter.getExpression2();
                boolean isLeftAttributeExp = false;
                if (exp1 == null) {
                    if (exp2 == null) {
                        return true;
                    }
                } else if (exp2 == null) {
                    isLeftAttributeExp = true;
                } else if (!(exp2 instanceof Literal) && !(exp1 instanceof Literal)) {
                    throw new UnsupportedOperationException("Comparison filters involving attributes of nested features are only supported if only one of the expressions compared is a literal.");
                }
                if (exp2 instanceof Literal) {
                    isLeftAttributeExp = true;
                }
                if (isLeftAttributeExp) {
                    for (Object val : values) {
                        compFilter.setExpression1((Expression)this.factory.literal(val));
                        if (!compFilter.evaluate(null)) continue;
                        ((BinaryComparisonAbstract)this.filter).setExpression1(exp1);
                        return true;
                    }
                    ((BinaryComparisonAbstract)this.filter).setExpression1(exp1);
                } else {
                    for (Object val : values) {
                        compFilter.setExpression2((Expression)this.factory.literal(val));
                        if (!compFilter.evaluate(null)) continue;
                        ((BinaryComparisonAbstract)this.filter).setExpression2(exp2);
                        return true;
                    }
                    ((BinaryComparisonAbstract)this.filter).setExpression2(exp2);
                }
            } else if (this.filter instanceof LikeFilterImpl) {
                for (Object val : values) {
                    ((LikeFilterImpl)this.filter).setExpression((Expression)this.factory.literal(val));
                    if (!this.filter.evaluate(null)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return null;
    }
}

