/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToEnvelopeFunction
implements Function {
    private final List<Expression> parameters;
    private final Literal fallback;
    public static final FunctionName NAME = new Name();

    public ToEnvelopeFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public ToEnvelopeFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return "ToEnvelope";
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        boolean crsexists = false;
        Envelope envelope = null;
        ReferencedEnvelope refenvelope = null;
        CoordinateReferenceSystem sourceCRS = null;
        if (this.parameters.size() <= 3) {
            Expression x = this.parameters.get(0);
            Expression y = this.parameters.get(1);
            double xvalue = (Double)x.evaluate(object, Double.class);
            double yvalue = (Double)y.evaluate(object, Double.class);
            if (this.parameters.size() == 3) {
                crsexists = true;
                Expression crs = this.parameters.get(2);
                String crsvalue = (String)crs.evaluate(object, String.class);
                try {
                    sourceCRS = CRS.decode((String)crsvalue);
                }
                catch (NoSuchAuthorityCodeException e) {
                    throw new IllegalArgumentException("Invalid or unsupported SRS name detected for toEnvelope function: " + crsvalue + ". Cause: " + e.getMessage());
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Unable to decode SRS name. Cause: " + e.getMessage());
                }
            }
            Coordinate coordinate = new Coordinate(xvalue, yvalue);
            envelope = new Envelope(coordinate);
            if (crsexists) {
                refenvelope = new ReferencedEnvelope(envelope, sourceCRS);
            }
        } else {
            Expression minx = this.parameters.get(0);
            Expression maxx = this.parameters.get(1);
            Expression miny = this.parameters.get(2);
            Expression maxy = this.parameters.get(3);
            double minxvalue = (Double)minx.evaluate(object, Double.class);
            double minyvalue = (Double)miny.evaluate(object, Double.class);
            double maxxvalue = (Double)maxx.evaluate(object, Double.class);
            double maxyvalue = (Double)maxy.evaluate(object, Double.class);
            if (this.parameters.size() == 5) {
                crsexists = true;
                Expression crs = this.parameters.get(4);
                String crsvalue = (String)crs.evaluate(object, String.class);
                try {
                    sourceCRS = CRS.decode((String)crsvalue);
                }
                catch (NoSuchAuthorityCodeException e) {
                    throw new IllegalArgumentException("Invalid or unsupported SRS name detected for toEnvelope function: " + crsvalue + ". Cause: " + e.getMessage());
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Unable to decode SRS name. Cause: " + e.getMessage());
                }
            }
            envelope = new Envelope(minxvalue, maxxvalue, minyvalue, maxyvalue);
            if (crsexists) {
                refenvelope = new ReferencedEnvelope(envelope, sourceCRS);
            }
        }
        if (crsexists) {
            return (T)Converters.convert((Object)refenvelope, context);
        }
        return (T)Converters.convert((Object)envelope, context);
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Name
    implements FunctionName {
        public int getArgumentCount() {
            return 2;
        }

        public List<String> getArgumentNames() {
            return Arrays.asList("minxvalue", "maxxvalue", "minyvalue", "maxyvalue", "crsvalue");
        }

        public String getName() {
            return "ToEnvelope";
        }
    }
}

