/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlXpathUtilites {
    public static List<String> getXPathValues(NamespaceSupport ns, String xpathString, Document doc) {
        JXPathContext context = XmlXpathUtilites.initialiseContext(ns, doc);
        return XmlXpathUtilites.getXPathValues(xpathString, context);
    }

    public static int countXPathNodes(NamespaceSupport ns, String xpathString, Document doc) {
        int count = 0;
        List<String> ls = XmlXpathUtilites.getXPathValues(ns, xpathString, doc);
        if (ls != null) {
            count = ls.size();
        }
        return count;
    }

    public static String getSingleXPathValue(NamespaceSupport ns, String xpathString, Document doc) {
        String id = null;
        JXPathContext context = XmlXpathUtilites.initialiseContext(ns, doc);
        try {
            Object ob = context.getValue(xpathString);
            id = (String)ob;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error reading xpath " + xpathString, e);
        }
        return id;
    }

    private static JXPathContext initialiseContext(NamespaceSupport ns, Document doc) {
        JXPathContext context = JXPathContext.newContext((Object)doc);
        XmlXpathUtilites.addNamespaces(ns, context);
        return context;
    }

    private static void addNamespaces(NamespaceSupport ns, JXPathContext context) {
        Enumeration<String> prefixes = ns.getPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String uri = ns.getURI(prefix);
            context.registerNamespace(prefix, uri);
        }
    }

    private static List<String> getXPathValues(String xpathString, JXPathContext context) {
        List values = null;
        try {
            values = context.selectNodes(xpathString);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error reading xpath " + xpathString, e);
        }
        ArrayList<String> ls = null;
        if (values == null) {
            ls = new ArrayList<String>();
        } else {
            ls = new ArrayList(values.size());
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                String unwrappedValue = "";
                if (value instanceof Attribute) {
                    unwrappedValue = ((Attribute)value).getValue();
                } else if (value instanceof Element) {
                    unwrappedValue = ((Element)value).getValue();
                }
                ls.add(unwrappedValue);
            }
        }
        return ls;
    }
}

