/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import com.vividsolutions.jts.util.Stopwatch;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.Types;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureChainingTest {
    static final String GSMLNS = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
    static final String GMLNS = "http://www.opengis.net/gml";
    static final Name MAPPED_FEATURE_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeatureType");
    static final Name MAPPED_FEATURE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"MappedFeature");
    static final Name GEOLOGIC_UNIT_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"GeologicUnitType");
    static final Name GEOLOGIC_UNIT = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"GeologicUnit");
    static final Name GEOLOGIC_UNIT_NAME = Types.typeName((String)"myGeologicUnit");
    static final Name COMPOSITION_PART_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CompositionPartType");
    static final Name COMPOSITION_PART = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CompositionPart");
    static final Name CGI_TERM_VALUE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CGI_TermValue");
    static final Name CGI_TERM_VALUE_TYPE = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"CGI_TermValueType");
    static final Name CONTROLLED_CONCEPT = Types.typeName((String)"urn:cgi:xmlns:CGI:GeoSciML:2.0", (String)"ControlledConcept");
    static FilterFactory ff = new FilterFactoryImpl(null);
    static final Map<String, String> mfToGuMap = new HashMap<String, String>(){
        {
            this.put("mf1", "gu.25699");
            this.put("mf2", "gu.25678");
            this.put("mf3", "gu.25678");
            this.put("mf4", "gu.25682");
        }
    };
    static final Map<String, String> guToCpMap = new HashMap<String, String>(){
        {
            this.put("gu.25699", "cp.167775491936278899");
            this.put("gu.25678", "cp.167775491936278844;cp.167775491936278856");
            this.put("gu.25682", "cp.167775491936278812");
        }
    };
    static final Map<String, String> guToExposureColorMap = new HashMap<String, String>(){
        {
            this.put("gu.25699", "Blue");
            this.put("gu.25678", "Yellow;Blue");
            this.put("gu.25682", "Red");
        }
    };
    static Map<String, String> guToOutcropCharacterMap = new HashMap<String, String>(){
        {
            this.put("gu.25699", "x");
            this.put("gu.25678", "x;y");
            this.put("gu.25682", "z");
        }
    };
    private static final String schemaBase = "/test-data/";
    private static FeatureSource<FeatureType, Feature> mfSource;
    private static FeatureCollection<FeatureType, Feature> mfFeatures;
    private static FeatureCollection<FeatureType, Feature> guFeatures;
    private static FeatureCollection<FeatureType, Feature> cpFeatures;
    private static FeatureCollection<FeatureType, Feature> ccFeatures;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Stopwatch sw = new Stopwatch();
        sw.start();
        FeatureChainingTest.loadDataAccesses();
        sw.stop();
        System.out.println("Set up time: " + sw.getTimeString());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DataAccessRegistry.unregisterAll();
    }

    @Test
    public void testFeatureChaining() throws Exception {
        Feature cpFeature;
        Feature guFeature;
        FeatureIterator mfIterator = mfFeatures.features();
        FeatureIterator guIterator = guFeatures.features();
        HashMap<String, Feature> guMap = new HashMap<String, Feature>();
        while (guIterator.hasNext()) {
            guFeature = guIterator.next();
            String guId = guFeature.getIdentifier().getID();
            if (guMap.containsKey(guId)) continue;
            guMap.put(guId, guFeature);
        }
        FeatureIterator cpIterator = cpFeatures.features();
        HashMap<String, Feature> cpMap = new HashMap<String, Feature>();
        while (cpIterator.hasNext()) {
            cpFeature = cpIterator.next();
            String cpId = cpFeature.getIdentifier().getID();
            if (cpMap.containsKey(cpId)) continue;
            cpMap.put(cpId, cpFeature);
        }
        String NESTED_LINK = "specification";
        while (mfIterator.hasNext()) {
            Feature mfFeature = mfIterator.next();
            String mfId = mfFeature.getIdentifier().toString();
            String[] guIds = mfToGuMap.get(mfId).split(";");
            Collection nestedGuFeatures = mfFeature.getProperties("specification");
            Assert.assertEquals((long)guIds.length, (long)nestedGuFeatures.size());
            ArrayList<String> nestedGuIds = new ArrayList<String>();
            for (Property property : nestedGuFeatures) {
                Object value = property.getValue();
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof Collection));
                Assert.assertEquals((long)1L, (long)((Collection)value).size());
                Feature nestedGuFeature = (Feature)((Collection)value).iterator().next();
                String guId = nestedGuFeature.getIdentifier().toString();
                Assert.assertTrue((boolean)guMap.containsKey(guId));
                nestedGuIds.add(guId);
                guFeature = (Feature)guMap.get(guId.toString());
                Collection guProperties = guFeature.getProperties();
                Assert.assertEquals((Object)nestedGuFeature.getProperties(), (Object)guProperties);
                String[] cpIds = guToCpMap.get(guId).split(";");
                Collection nestedCpFeatures = guFeature.getProperties("composition");
                Assert.assertEquals((long)cpIds.length, (long)nestedCpFeatures.size());
                ArrayList<String> nestedCpIds = new ArrayList<String>();
                for (Property cpProperty : nestedCpFeatures) {
                    Object cpPropertyValue = cpProperty.getValue();
                    Assert.assertNotNull((Object)cpPropertyValue);
                    Assert.assertTrue((boolean)(cpPropertyValue instanceof Collection));
                    Assert.assertEquals((long)1L, (long)((Collection)cpPropertyValue).size());
                    Feature nestedCpFeature = (Feature)((Collection)cpPropertyValue).iterator().next();
                    String cpId = nestedCpFeature.getIdentifier().toString();
                    Assert.assertTrue((boolean)cpMap.containsKey(cpId));
                    nestedCpIds.add(cpId);
                    cpFeature = (Feature)cpMap.get(cpId.toString());
                    Collection cpProperties = cpFeature.getProperties();
                    Assert.assertEquals((Object)nestedCpFeature.getProperties(), (Object)cpProperties);
                }
                Assert.assertTrue((boolean)nestedCpIds.containsAll(Arrays.asList(cpIds)));
            }
            Assert.assertTrue((boolean)nestedGuIds.containsAll(Arrays.asList(guIds)));
        }
        mfIterator.close();
        guIterator.close();
        cpIterator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManyOnChainedSide() throws Exception {
        String LITHOLOGY = "lithology";
        AbstractMappingFeatureIterator iterator = (AbstractMappingFeatureIterator)ccFeatures.features();
        int count = 0;
        HashMap<String, Feature> featureList = new HashMap<String, Feature>();
        try {
            while (iterator.hasNext()) {
                Feature f = iterator.next();
                featureList.put(f.getIdentifier().getID(), f);
                ++count;
            }
        }
        finally {
            iterator.close();
        }
        Assert.assertEquals((long)5L, (long)count);
        FeatureIterator cpIterator = cpFeatures.features();
        while (cpIterator.hasNext()) {
            Feature cpFeature = cpIterator.next();
            Collection lithologies = cpFeature.getProperties("lithology");
            if (cpFeature.getIdentifier().toString().equals("cp.167775491936278812")) {
                Assert.assertEquals((long)2L, (long)lithologies.size());
                ArrayList<String> lithologyIds = new ArrayList<String>();
                for (Property lithologyProperty : lithologies) {
                    Feature nestedFeature = (Feature)((Collection)lithologyProperty.getValue()).iterator().next();
                    String fId = nestedFeature.getIdentifier().getID();
                    lithologyIds.add(fId);
                    Feature lithology = (Feature)featureList.get(fId);
                    Assert.assertEquals((Object)nestedFeature.getProperties(), (Object)lithology.getProperties());
                }
                Assert.assertTrue((boolean)featureList.keySet().containsAll(lithologyIds));
                continue;
            }
            Assert.assertEquals((long)1L, (long)lithologies.size());
        }
    }

    @Test
    public void testMultipleMultiValuedProperties() throws Exception {
        FeatureIterator guIterator = guFeatures.features();
        String EXPOSURE_COLOR = "exposureColor";
        String OUTCROP_CHARACTER = "outcropCharacter";
        while (guIterator.hasNext()) {
            Feature guFeature = guIterator.next();
            String guId = guFeature.getIdentifier().toString();
            ArrayList<Object> realValues = new ArrayList<Object>();
            Collection nestedTermValues = guFeature.getProperties("exposureColor");
            for (Property property : nestedTermValues) {
                Object value = property.getValue();
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof Collection));
                Assert.assertEquals((long)1L, (long)((Collection)value).size());
                Feature feature = (Feature)((Collection)value).iterator().next();
                for (Property nestedProperty : feature.getProperties("value")) {
                    realValues.add(((Property)((Collection)nestedProperty.getValue()).iterator().next()).getValue());
                }
            }
            String[] values = guToExposureColorMap.get(guId).split(";");
            Assert.assertEquals((long)realValues.size(), (long)values.length);
            Assert.assertTrue((boolean)realValues.containsAll(Arrays.asList(values)));
            nestedTermValues = guFeature.getProperties("outcropCharacter");
            realValues.clear();
            for (Property property : nestedTermValues) {
                Object value = property.getValue();
                Assert.assertNotNull((Object)value);
                Assert.assertTrue((boolean)(value instanceof Collection));
                Assert.assertEquals((long)1L, (long)((Collection)value).size());
                Feature feature = (Feature)((Collection)value).iterator().next();
                for (Property nestedProperty : feature.getProperties("value")) {
                    realValues.add(((Property)((Collection)nestedProperty.getValue()).iterator().next()).getValue());
                }
            }
            values = guToOutcropCharacterMap.get(guId).split(";");
            Assert.assertEquals((long)realValues.size(), (long)values.length);
            Assert.assertTrue((boolean)realValues.containsAll(Arrays.asList(values)));
        }
        guIterator.close();
    }

    @Test
    public void testMultiValuedSimpleProperties() throws Exception {
        FeatureIterator iterator = ccFeatures.features();
        while (iterator.hasNext()) {
            Feature next = iterator.next();
            Collection names = next.getProperties("name");
            if (next.getIdentifier().toString().equals("cc.1")) {
                Assert.assertEquals((long)6L, (long)names.size());
                continue;
            }
            Assert.assertEquals((long)2L, (long)names.size());
        }
        iterator.close();
    }

    @Test
    public void testFilters() throws Exception {
        PropertyName property = ff.property("gsml:specification/gsml:GeologicUnit/gml:description");
        PropertyIsLike filter = ff.like((Expression)property, "Olivine basalt, tuff, microgabbro, minor sedimentary rocks");
        FeatureCollection filteredResults = mfSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)3L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)filteredResults));
        FeatureIterator iterator = filteredResults.features();
        Feature feature = iterator.next();
        Assert.assertEquals((Object)"mf1", (Object)feature.getIdentifier().toString());
        feature = iterator.next();
        Assert.assertEquals((Object)"mf2", (Object)feature.getIdentifier().toString());
        feature = iterator.next();
        Assert.assertEquals((Object)"mf3", (Object)feature.getIdentifier().toString());
        iterator.close();
        FeatureSource guSource = AppSchemaDataAccessRegistry.getFeatureSource((Name)GEOLOGIC_UNIT_NAME);
        property = ff.property("gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value");
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"significant"));
        filteredResults = guSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)2L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)filteredResults));
        iterator = filteredResults.features();
        feature = iterator.next();
        Assert.assertEquals((Object)"gu.25678", (Object)feature.getIdentifier().toString());
        feature = iterator.next();
        Assert.assertEquals((Object)"gu.25682", (Object)feature.getIdentifier().toString());
        iterator.close();
        property = ff.property("gsml:specification/gsml:GeologicUnit/gsml:occurrence/@xlink:href");
        filter = ff.like((Expression)property, "urn:cgi:feature:MappedFeature:mf1");
        filteredResults = mfSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)filteredResults));
        feature = filteredResults.features().next();
        Assert.assertEquals((Object)"mf1", (Object)feature.getIdentifier().toString());
        property = ff.property("gml:name");
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"Yaugher Volcanic Group 2"));
        filteredResults = guSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)filteredResults));
        feature = filteredResults.features().next();
        Assert.assertEquals((Object)"gu.25678", (Object)feature.getIdentifier().toString());
        Collection properties = feature.getProperties(Types.typeName((String)GMLNS, (String)"name"));
        Assert.assertTrue((properties.size() == 3 ? 1 : 0) != 0);
        Iterator propIterator = properties.iterator();
        ComplexAttribute complexAttribute = (ComplexAttribute)propIterator.next();
        Collection values = complexAttribute.getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"Yaugher Volcanic Group 1", (Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute));
        complexAttribute = (ComplexAttribute)propIterator.next();
        values = complexAttribute.getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"Yaugher Volcanic Group 2", (Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute));
        complexAttribute = (ComplexAttribute)propIterator.next();
        values = complexAttribute.getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"-Py", (Object)GML3EncodingUtils.getSimpleContent((ComplexAttribute)complexAttribute));
        property = ff.property("gsml:exposureColor/gsml:CGI_TermValue/gsml:value");
        filter = ff.equals((Expression)property, (Expression)ff.literal((Object)"Yellow"));
        filteredResults = guSource.getFeatures((Filter)filter);
        Assert.assertEquals((long)1L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)filteredResults));
        feature = filteredResults.features().next();
        Assert.assertEquals((Object)"gu.25678", (Object)feature.getIdentifier().toString());
        properties = feature.getProperties(Types.typeName((String)GSMLNS, (String)"exposureColor"));
        Assert.assertTrue((properties.size() == 2 ? 1 : 0) != 0);
        propIterator = properties.iterator();
        values = (Collection)((Property)propIterator.next()).getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        Feature cgiFeature = (Feature)values.iterator().next();
        Assert.assertEquals((Object)"Yellow", (Object)cgiFeature.getIdentifier().toString());
        values = (Collection)((Property)propIterator.next()).getValue();
        Assert.assertEquals((long)1L, (long)values.size());
        cgiFeature = (Feature)values.iterator().next();
        Assert.assertEquals((Object)"Blue", (Object)cgiFeature.getIdentifier().toString());
    }

    @Test
    public void testComplexTypeWithSimpleContent() throws Exception {
        Feature feature;
        Object value;
        Collection children;
        Feature next;
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = this.getClass().getResource("/test-data/FirstParentFeature.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        Name typeName = Types.typeName((String)"http://example.com", (String)"FirstParentFeature");
        FeatureType featureType = dataAccess.getSchema(typeName);
        Assert.assertNotNull((Object)featureType);
        FeatureSource fSource = dataAccess.getFeatureSource(typeName);
        FeatureCollection features = fSource.getFeatures();
        Assert.assertEquals((long)5L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)features));
        FeatureIterator iterator = features.features();
        while (iterator.hasNext()) {
            next = iterator.next();
            children = next.getProperties("nestedFeature");
            if (next.getIdentifier().toString().equals("cc.1")) {
                Assert.assertEquals((long)2L, (long)children.size());
            } else {
                Assert.assertEquals((long)0L, (long)children.size());
            }
            for (Property nestedFeature : children) {
                value = nestedFeature.getValue();
                Assert.assertNotNull((Object)value);
                value = ((Collection)value).iterator().next();
                Assert.assertTrue((boolean)(value instanceof FeatureImpl));
                feature = (Feature)value;
                Assert.assertNotNull((Object)feature.getProperty("someAttribute").getValue());
            }
        }
        dsParams = new HashMap();
        url = this.getClass().getResource("/test-data/SecondParentFeature.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        dataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)dataAccess);
        typeName = Types.typeName((String)"http://example.com", (String)"SecondParentFeature");
        featureType = dataAccess.getSchema(typeName);
        Assert.assertNotNull((Object)featureType);
        fSource = dataAccess.getFeatureSource(typeName);
        features = fSource.getFeatures();
        Assert.assertEquals((long)5L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)features));
        iterator = features.features();
        while (iterator.hasNext()) {
            next = iterator.next();
            children = next.getProperties("nestedFeature");
            if (next.getIdentifier().toString().equals("cc.2")) {
                Assert.assertEquals((long)3L, (long)children.size());
            } else {
                Assert.assertEquals((long)0L, (long)children.size());
            }
            for (Property nestedFeature : children) {
                value = nestedFeature.getValue();
                Assert.assertNotNull((Object)value);
                value = ((Collection)value).iterator().next();
                Assert.assertTrue((boolean)(value instanceof FeatureImpl));
                feature = (Feature)value;
                Assert.assertNotNull((Object)feature.getProperty("someAttribute").getValue());
            }
        }
        dataAccess.dispose();
    }

    @Test
    public void testMultiValuedPropertiesByRef() throws Exception {
        String MF_PREFIX = "urn:cgi:feature:MappedFeature:";
        String OCCURENCE = "occurrence";
        HashMap<String, String> guToOccurrenceMap = new HashMap<String, String>(){
            {
                this.put("gu.25699", "mf1");
                this.put("gu.25678", "mf2;mf3");
                this.put("gu.25682", "mf4");
            }
        };
        ArrayList<String> processedFeatureIds = new ArrayList<String>();
        FeatureIterator guIterator = guFeatures.features();
        while (guIterator.hasNext()) {
            Feature guFeature = guIterator.next();
            String guId = guFeature.getIdentifier().toString();
            String[] mfIds = ((String)guToOccurrenceMap.get(guId)).split(";");
            Collection properties = guFeature.getProperties("occurrence");
            Assert.assertEquals((long)mfIds.length, (long)properties.size());
            int propertyIndex = 0;
            for (Property property : properties) {
                Object clientProps = property.getUserData().get(Attributes.class);
                Assert.assertNotNull(clientProps);
                Assert.assertTrue((boolean)(clientProps instanceof HashMap));
                Object hrefValue = ((Map)clientProps).get(AbstractMappingFeatureIterator.XLINK_HREF_NAME);
                Assert.assertEquals((Object)("urn:cgi:feature:MappedFeature:" + mfIds[propertyIndex]), hrefValue);
                Assert.assertTrue((boolean)((Collection)property.getValue()).isEmpty());
                ++propertyIndex;
            }
            processedFeatureIds.add(guId);
        }
        Assert.assertEquals((long)guToOccurrenceMap.size(), (long)processedFeatureIds.size());
        Assert.assertTrue((boolean)processedFeatureIds.containsAll(guToOccurrenceMap.keySet()));
        guIterator.close();
    }

    private static void loadDataAccesses() throws Exception {
        HashMap<String, String> dsParams = new HashMap<String, String>();
        URL url = FeatureChainingTest.class.getResource("/test-data/MappedFeaturePropertyfile.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("dbtype", "app-schema");
        dsParams.put("url", url.toExternalForm());
        DataAccess mfDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)mfDataAccess);
        FeatureType mappedFeatureType = mfDataAccess.getSchema(MAPPED_FEATURE);
        Assert.assertNotNull((Object)mappedFeatureType);
        mfSource = mfDataAccess.getFeatureSource(MAPPED_FEATURE);
        mfFeatures = mfSource.getFeatures();
        url = FeatureChainingTest.class.getResource("/test-data/GeologicUnit.xml");
        Assert.assertNotNull((Object)url);
        dsParams.put("url", url.toExternalForm());
        DataAccess guDataAccess = DataAccessFinder.getDataStore(dsParams);
        Assert.assertNotNull((Object)guDataAccess);
        FeatureType guType = guDataAccess.getSchema(GEOLOGIC_UNIT);
        Assert.assertNotNull((Object)guType);
        FeatureSource guSource = guDataAccess.getFeatureSource(GEOLOGIC_UNIT);
        guFeatures = guSource.getFeatures();
        cpFeatures = DataAccessRegistry.getFeatureSource((Name)COMPOSITION_PART).getFeatures();
        FeatureCollection cgiFeatures = DataAccessRegistry.getFeatureSource((Name)CGI_TERM_VALUE).getFeatures();
        ccFeatures = DataAccessRegistry.getFeatureSource((Name)CONTROLLED_CONCEPT).getFeatures();
        Assert.assertEquals((long)4L, (long)FeatureChainingTest.size(mfFeatures));
        Assert.assertEquals((long)3L, (long)FeatureChainingTest.size(guFeatures));
        Assert.assertEquals((long)4L, (long)FeatureChainingTest.size(cpFeatures));
        Assert.assertEquals((long)6L, (long)FeatureChainingTest.size((FeatureCollection<FeatureType, Feature>)cgiFeatures));
    }

    private static int size(FeatureCollection<FeatureType, Feature> features) {
        int size = 0;
        Iterator i = features.iterator();
        while (i.hasNext()) {
            ++size;
            i.next();
        }
        return size;
    }
}

