/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AbstractMappingFeatureIterator;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.xlink.XLINK;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessMappingFeatureIterator
extends AbstractMappingFeatureIterator {
    public static final Name XLINK_HREF_NAME = Types.toTypeName(XLINK.HREF);
    protected Iterator<Feature> sourceFeatureIterator;
    private CoordinateReferenceSystem reprojection;
    private Feature curSrcFeature;
    private FeatureSource<FeatureType, Feature> mappedSource;
    private FeatureCollection<FeatureType, Feature> sourceFeatures;

    public DataAccessMappingFeatureIterator(AppSchemaDataAccess store, FeatureTypeMapping mapping, Query query) throws IOException {
        super(store, mapping, query);
    }

    @Override
    public boolean hasNext() {
        if (this.isHasNextCalled()) {
            return this.curSrcFeature != null;
        }
        boolean exists = false;
        if (this.sourceFeatureIterator != null && this.featureCounter < this.maxFeatures && (exists = this.sourceFeatureIterator.hasNext()) && this.curSrcFeature == null) {
            this.curSrcFeature = this.sourceFeatureIterator.next();
        }
        if (!exists) {
            LOGGER.finest("no more features, produced " + this.featureCounter);
            this.close();
            this.curSrcFeature = null;
        }
        this.setHasNextCalled(true);
        return exists;
    }

    protected Iterator<Feature> getSourceFeatureIterator() {
        return this.sourceFeatureIterator;
    }

    @Override
    protected boolean isSourceFeatureIteratorNull() {
        return this.getSourceFeatureIterator() == null;
    }

    @Override
    protected void initialiseSourceFeatures(FeatureTypeMapping mapping, Query query) throws IOException {
        this.mappedSource = mapping.getSource();
        this.sourceFeatures = this.mappedSource.getFeatures(query);
        this.sourceFeatureIterator = this.sourceFeatures.iterator();
        this.reprojection = query.getCoordinateSystemReproject();
    }

    @Override
    protected boolean unprocessedFeatureExists() {
        boolean exists = this.sourceFeatureIterator.hasNext();
        if (exists && this.curSrcFeature == null) {
            this.curSrcFeature = this.sourceFeatureIterator.next();
        }
        return exists;
    }

    @Override
    protected String extractIdForFeature() {
        return this.extractIdForFeature(this.curSrcFeature);
    }

    private String extractIdForFeature(Feature feature) {
        Feature sourceInstance = feature;
        String fid = (String)this.featureFidMapping.evaluate((Object)sourceInstance, String.class);
        return fid;
    }

    @Override
    protected String extractIdForAttribute(Expression idExpression, Object sourceInstance) {
        String value = (String)idExpression.evaluate(sourceInstance, String.class);
        return value;
    }

    @Override
    protected boolean isNextSourceFeatureNull() {
        return this.curSrcFeature == null;
    }

    @Override
    protected boolean sourceFeatureIteratorHasNext() {
        return this.getSourceFeatureIterator().hasNext();
    }

    protected Object getValues(boolean isMultiValued, Expression expression, Object sourceFeatureInput) {
        if (isMultiValued && sourceFeatureInput instanceof FeatureImpl && expression instanceof AttributeExpressionImpl) {
            AttributeExpressionImpl attribExpression = (AttributeExpressionImpl)expression;
            String xpath = attribExpression.getPropertyName();
            ComplexAttribute sourceFeature = (ComplexAttribute)sourceFeatureInput;
            XPath.StepList xpathSteps = XPath.steps(sourceFeature.getDescriptor(), xpath, this.namespaces);
            ArrayList<Object> values = new ArrayList<Object>();
            Collection<Property> properties = this.getProperties(sourceFeature, xpathSteps);
            for (Property property : properties) {
                Object value = property.getValue();
                if (value == null) continue;
                if (value instanceof Collection) {
                    values.addAll((Collection)property.getValue());
                    continue;
                }
                values.add(property.getValue());
            }
            return values;
        }
        return this.getValue(expression, sourceFeatureInput);
    }

    /*
     * WARNING - void declaration
     */
    protected void setAttributeValue(Feature target, ComplexAttribute source, AttributeMapping attMapping) throws IOException {
        Expression sourceExpression = attMapping.getSourceExpression();
        AttributeType targetNodeType = attMapping.getTargetNodeInstance();
        XPath.StepList xpath = attMapping.getTargetXPath();
        Map<Name, Expression> clientPropsMappings = attMapping.getClientProperties();
        boolean isNestedFeature = attMapping.isNestedAttribute();
        Collection<Feature> value = this.getValues(attMapping.isMultiValued(), sourceExpression, source);
        boolean isHRefLink = this.isByReference(clientPropsMappings, isNestedFeature);
        if (isNestedFeature) {
            if (value instanceof Collection) {
                ArrayList<Feature> nestedFeatures = new ArrayList<Feature>(((Collection)value).size());
                for (Object object : (Collection)value) {
                    void var13_13;
                    while (var13_13 instanceof Attribute) {
                        Object object2 = ((Attribute)var13_13).getValue();
                    }
                    if (isHRefLink) {
                        nestedFeatures.addAll(((NestedAttributeMapping)attMapping).getInputFeatures(var13_13, this.reprojection));
                        continue;
                    }
                    nestedFeatures.addAll(((NestedAttributeMapping)attMapping).getFeatures(var13_13, this.reprojection));
                }
                value = nestedFeatures;
            } else {
                value = isHRefLink ? ((NestedAttributeMapping)attMapping).getInputFeatures(value, this.reprojection) : ((NestedAttributeMapping)attMapping).getFeatures(value, this.reprojection);
            }
            if (isHRefLink) {
                this.setXlinkReference(target, clientPropsMappings, value, xpath, targetNodeType);
                return;
            }
        }
        String id = null;
        if (Expression.NIL != attMapping.getIdentifierExpression()) {
            id = this.extractIdForAttribute(attMapping.getIdentifierExpression(), source);
        }
        if (isNestedFeature) assert (value instanceof Collection);
        if (value instanceof Collection) {
            for (Object object : value) {
                ArrayList<Property> valueList = new ArrayList<Property>();
                valueList.add((Property)object);
                Attribute instance = this.xpathAttributeBuilder.set((Attribute)target, xpath, valueList, id, targetNodeType, false);
                this.setClientProperties(instance, source, clientPropsMappings);
            }
        } else {
            Attribute instance = this.xpathAttributeBuilder.set((Attribute)target, xpath, value, id, targetNodeType, false);
            this.setClientProperties(instance, source, clientPropsMappings);
        }
    }

    protected void setXlinkReference(Feature target, Map<Name, Expression> clientPropsMappings, Object value, XPath.StepList xpath, AttributeType targetNodeType) {
        Property existingAttribute = this.getProperty((ComplexAttribute)target, xpath);
        if (existingAttribute != null) {
            Object existingValue = existingAttribute.getUserData().get(Attributes.class);
            if (existingValue != null) {
                assert (existingValue instanceof HashMap);
                existingValue = ((Map)existingValue).get(XLINK_HREF_NAME);
            }
            if (existingValue != null) {
                Expression linkExpression = clientPropsMappings.get(XLINK_HREF_NAME);
                for (Object singleVal : (Collection)value) {
                    assert (singleVal instanceof Feature);
                    assert (linkExpression != null);
                    Object hrefValue = linkExpression.evaluate(singleVal);
                    if (hrefValue == null || !hrefValue.equals(existingValue)) continue;
                    return;
                }
            }
        }
        for (Object singleVal : (Collection)value) {
            assert (singleVal instanceof Feature);
            Attribute instance = this.xpathAttributeBuilder.set((Attribute)target, xpath, null, null, targetNodeType, true);
            this.setClientProperties(instance, singleVal, clientPropsMappings);
        }
    }

    @Override
    protected void setClientProperties(Attribute target, Object source, Map<Name, Expression> clientProperties) {
        if (clientProperties.size() == 0) {
            return;
        }
        HashMap<Name, Object> targetAttributes = new HashMap<Name, Object>();
        for (Map.Entry<Name, Expression> entry : clientProperties.entrySet()) {
            Name propName = entry.getKey();
            Expression propExpr = entry.getValue();
            Object propValue = this.getValue(propExpr, source);
            targetAttributes.put(propName, propValue);
        }
        target.getUserData().put(Attributes.class, targetAttributes);
    }

    @Override
    protected Feature computeNext() throws IOException {
        assert (this.curSrcFeature != null) : "hasNext not called?";
        String id = this.extractIdForFeature(this.curSrcFeature);
        ArrayList<Feature> sources = new ArrayList<Feature>();
        sources.add(this.curSrcFeature);
        while (this.sourceFeatureIterator.hasNext()) {
            Feature next = this.sourceFeatureIterator.next();
            if (this.extractIdForFeature(next).equals(id)) {
                sources.add(next);
                this.curSrcFeature = null;
                continue;
            }
            this.curSrcFeature = next;
            this.setHasNextCalled(true);
            break;
        }
        AttributeDescriptor targetNode = this.mapping.getTargetFeature();
        Name targetNodeName = targetNode.getName();
        List<AttributeMapping> mappings = this.mapping.getAttributeMappings();
        AttributeBuilder builder = new AttributeBuilder(this.attf);
        builder.setDescriptor(targetNode);
        Feature target = (Feature)builder.build(id);
        for (AttributeMapping attMapping : mappings) {
            XPath.Step rootStep;
            QName stepName;
            XPath.StepList targetXpathProperty = attMapping.getTargetXPath();
            if (targetXpathProperty.size() == 1 && Types.equals(targetNodeName, stepName = (rootStep = (XPath.Step)targetXpathProperty.get(0)).getName())) continue;
            for (Feature source : sources) {
                this.setAttributeValue(target, (ComplexAttribute)source, attMapping);
            }
        }
        ++this.featureCounter;
        if (target.getDefaultGeometryProperty() == null) {
            this.setGeometry(target);
        }
        return target;
    }

    @Override
    protected Feature populateFeatureData(String id) throws IOException {
        throw new UnsupportedOperationException("populateFeatureData should not be called!");
    }

    @Override
    protected void closeSourceFeatures() {
        if (this.sourceFeatures != null && this.getSourceFeatureIterator() != null) {
            this.sourceFeatures.close(this.sourceFeatureIterator);
            this.sourceFeatureIterator = null;
            this.sourceFeatures = null;
        }
    }

    @Override
    protected Object getValue(Expression expression, Object sourceFeature) {
        Object value = expression.evaluate(sourceFeature);
        if (value instanceof Attribute) {
            value = ((Attribute)value).getValue();
        }
        return value;
    }

    private Property getProperty(ComplexAttribute root, XPath.StepList xpath) {
        ComplexAttribute property = root;
        XPath.StepList steps = new XPath.StepList(xpath);
        Iterator stepsIterator = steps.iterator();
        while (stepsIterator.hasNext()) {
            assert (property instanceof ComplexAttribute);
            XPath.Step step = (XPath.Step)stepsIterator.next();
            if ((property = property.getProperty(Types.toTypeName(step.getName()))) != null) continue;
            return null;
        }
        return property;
    }

    private Collection<Property> getProperties(ComplexAttribute root, XPath.StepList xpath) {
        XPath.StepList steps = new XPath.StepList(xpath);
        Iterator stepsIterator = steps.iterator();
        Collection properties = null;
        XPath.Step step = null;
        if (stepsIterator.hasNext()) {
            step = (XPath.Step)stepsIterator.next();
            properties = root.getProperties(Types.toTypeName(step.getName()));
        }
        while (stepsIterator.hasNext()) {
            step = (XPath.Step)stepsIterator.next();
            ArrayList nestedProperties = new ArrayList();
            for (Property property : properties) {
                assert (property instanceof ComplexAttribute);
                Collection tempProperties = ((ComplexAttribute)property).getProperties(Types.toTypeName(step.getName()));
                if (tempProperties.isEmpty()) continue;
                nestedProperties.addAll(tempProperties);
            }
            properties.clear();
            if (nestedProperties.isEmpty()) {
                return properties;
            }
            properties.addAll(nestedProperties);
        }
        return properties;
    }

    protected boolean isByReference(Map<Name, Expression> clientPropsMappings, boolean isNested) {
        return isNested ? (clientPropsMappings.isEmpty() ? false : clientPropsMappings.get(XLINK_HREF_NAME) != null) : false;
    }
}

