/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.filter.XPath;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.FilterFactoryImplNamespaceAware;
import org.geotools.filter.NestedAttributeExpression;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAttributeMapping
extends AttributeMapping {
    private FeatureSource<FeatureType, Feature> source;
    private FeatureSource<FeatureType, Feature> mappingSource;
    private final Name nestedFeatureType;
    private final XPath.StepList nestedTargetXPath;
    private Expression nestedSourceExpression;
    private FilterFactory filterFac;

    public NestedAttributeMapping(Expression idExpression, Expression parentExpression, XPath.StepList targetXPath, boolean isMultiValued, Map<Name, Expression> clientProperties, Name sourceElement, XPath.StepList sourcePath, NamespaceSupport namespaces) throws IOException {
        super(idExpression, parentExpression, targetXPath, null, isMultiValued, clientProperties);
        this.nestedTargetXPath = sourcePath;
        this.nestedFeatureType = sourceElement;
        this.filterFac = new FilterFactoryImplNamespaceAware(namespaces);
    }

    @Override
    public boolean isNestedAttribute() {
        return true;
    }

    public Collection<Feature> getInputFeatures(Object foreignKeyValue, CoordinateReferenceSystem reprojection) throws IOException {
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        if (this.source == null) {
            FeatureTypeMapping featureTypeMapping = AppSchemaDataAccessRegistry.getMapping(this.nestedFeatureType);
            assert (featureTypeMapping != null);
            this.source = featureTypeMapping.getSource();
            assert (this.source != null);
            AttributeMapping mapping = featureTypeMapping.getAttributeMapping(this.nestedTargetXPath);
            assert (mapping != null);
            this.nestedSourceExpression = mapping.getSourceExpression();
        }
        assert (this.nestedSourceExpression != null);
        PropertyIsEqualTo filter = this.filterFac.equals(this.nestedSourceExpression, (Expression)this.filterFac.literal(foreignKeyValue));
        DefaultQuery query = new DefaultQuery();
        query.setCoordinateSystemReproject(reprojection);
        query.setFilter((Filter)filter);
        FeatureCollection fCollection = this.source.getFeatures((Query)query);
        Iterator it = fCollection.iterator();
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            Object value = this.nestedSourceExpression.evaluate((Object)feature);
            if (value == null || !value.equals(foreignKeyValue)) continue;
            matchingFeatures.add(feature);
        }
        fCollection.close(it);
        return matchingFeatures;
    }

    public Collection<Feature> getFeatures(Object foreignKeyValue, CoordinateReferenceSystem reprojection) throws IOException {
        if (this.mappingSource == null) {
            this.mappingSource = DataAccessRegistry.getFeatureSource(this.nestedFeatureType);
        }
        assert (this.mappingSource != null);
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        Object propertyName = null;
        propertyName = !(this.mappingSource instanceof MappingFeatureSource) ? new NestedAttributeExpression(this.nestedTargetXPath.toString(), reprojection) : this.filterFac.property(this.nestedTargetXPath.toString());
        PropertyIsEqualTo filter = this.filterFac.equals((Expression)propertyName, (Expression)this.filterFac.literal(foreignKeyValue));
        DefaultQuery query = new DefaultQuery();
        query.setCoordinateSystemReproject(reprojection);
        query.setFilter((Filter)filter);
        FeatureCollection fCollection = this.mappingSource.getFeatures((Query)query);
        Iterator iterator = fCollection.iterator();
        while (iterator.hasNext()) {
            matchingFeatures.add((Feature)iterator.next());
        }
        fCollection.close(iterator);
        return matchingFeatures;
    }

    public Name getNestedFeatureType() {
        return this.nestedFeatureType;
    }
}

