/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.xml.resolver.Catalog;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.FeatureTypeMappingFactory;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.TreeAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.CatalogUtilities;
import org.geotools.data.complex.config.EmfAppSchemaReader;
import org.geotools.data.complex.config.FeatureTypeRegistry;
import org.geotools.data.complex.config.SourceDataStore;
import org.geotools.data.complex.config.TypeMapping;
import org.geotools.data.complex.filter.XPath;
import org.geotools.factory.Hints;
import org.geotools.feature.Types;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.expression.FeaturePropertyAccessorFactory;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.util.logging.Logging;
import org.geotools.xml.SchemaIndex;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.xml.sax.helpers.NamespaceSupport;

public class AppSchemaDataAccessConfigurator {
    private static final Logger LOGGER = Logging.getLogger((String)AppSchemaDataAccessConfigurator.class.getPackage().getName());
    private AppSchemaDataAccessDTO config;
    private Map<String, String> resolvedSchemaLocations;
    private FeatureTypeRegistry typeRegistry;
    private Map sourceDataStores;
    private NamespaceSupport namespaces;
    private ArrayList<String> inputDataAccessIds;

    private AppSchemaDataAccessConfigurator(AppSchemaDataAccessDTO config) {
        this.config = config;
        this.namespaces = new NamespaceSupport();
        this.inputDataAccessIds = new ArrayList();
        this.resolvedSchemaLocations = new HashMap<String, String>();
        Map nsMap = config.getNamespaces();
        for (Map.Entry entry : nsMap.entrySet()) {
            String prefix = (String)entry.getKey();
            String namespace = (String)entry.getValue();
            this.namespaces.declarePrefix(prefix, namespace);
        }
    }

    public static Set buildMappings(AppSchemaDataAccessDTO config) throws IOException {
        AppSchemaDataAccessConfigurator mappingsBuilder = new AppSchemaDataAccessConfigurator(config);
        Set mappingObjects = mappingsBuilder.buildMappings();
        return mappingObjects;
    }

    private Set buildMappings() throws IOException {
        this.parseGmlSchemas();
        this.sourceDataStores = this.aquireSourceDatastores();
        Set featureTypeMappings = this.createFeatureTypeMappings();
        return featureTypeMappings;
    }

    private Set createFeatureTypeMappings() throws IOException {
        Set mappingsConfigs = this.config.getTypeMappings();
        HashSet<FeatureTypeMapping> featureTypeMappings = new HashSet<FeatureTypeMapping>();
        for (TypeMapping dto : mappingsConfigs) {
            String schemaURI;
            AttributeDescriptor target;
            String nsURI;
            FeatureSource featureSource = this.getFeatureSource(dto);
            GeometryType geomType = null;
            GeometryDescriptor defaultGeom = featureSource.getSchema().getGeometryDescriptor();
            if (defaultGeom != null) {
                geomType = defaultGeom.getType();
            }
            if ((nsURI = (target = this.getTargetDescriptor(dto, geomType)).getName().getNamespaceURI()) != null && (schemaURI = this.resolvedSchemaLocations.get(nsURI)) != null) {
                target.getType().getUserData().put("schemaURI", schemaURI);
            }
            List attMappings = this.getAttributeMappings(target, dto.getAttributeMappings(), dto.getItemXpath());
            FeatureTypeMapping mapping = FeatureTypeMappingFactory.getInstance(featureSource, target, attMappings, this.namespaces, dto.getItemXpath(), dto.isXmlDataStore());
            featureTypeMappings.add(mapping);
        }
        return featureTypeMappings;
    }

    private AttributeDescriptor getTargetDescriptor(TypeMapping dto, GeometryType geomType) throws IOException {
        String prefixedTargetName = dto.getTargetElementName();
        Name targetNodeName = this.degloseName(prefixedTargetName);
        AttributeDescriptor targetDescriptor = this.typeRegistry.getDescriptor(targetNodeName, geomType, dto.getAttributeMappings());
        if (targetDescriptor == null) {
            throw new NoSuchElementException("descriptor " + targetNodeName + " not found in parsed schema");
        }
        return targetDescriptor;
    }

    private List getAttributeMappings(AttributeDescriptor root, List attDtos, String itemXpath) throws IOException {
        LinkedList<AttributeMapping> attMappings = new LinkedList<AttributeMapping>();
        for (org.geotools.data.complex.config.AttributeMapping attDto : attDtos) {
            AttributeMapping attMapping;
            AttributeType expectedInstanceOf;
            String idExpr = attDto.getIdentifierExpression();
            String idXpath = null;
            if (idExpr == null && (idXpath = attDto.getIdentifierPath()) != null) {
                XPath.StepList inputXPathSteps = XPath.steps(root, itemXpath + "/" + idXpath, this.namespaces);
                this.validateConfiguredNamespaces(inputXPathSteps);
            }
            String sourceExpr = attDto.getSourceExpression();
            String inputXPath = null;
            if (sourceExpr == null && (inputXPath = attDto.getInputAttributePath()) != null) {
                XPath.StepList inputXPathSteps = XPath.steps(root, itemXpath + "/" + inputXPath, this.namespaces);
                this.validateConfiguredNamespaces(inputXPathSteps);
            }
            String expectedInstanceTypeName = attDto.getTargetAttributeSchemaElement();
            String targetXPath = attDto.getTargetAttributePath();
            XPath.StepList targetXPathSteps = XPath.steps(root, targetXPath, this.namespaces);
            this.validateConfiguredNamespaces(targetXPathSteps);
            boolean isMultiValued = attDto.isMultiple();
            AttributeExpressionImpl idExpression = idXpath == null ? this.parseOgcCqlExpression(idExpr) : new AttributeExpressionImpl(idXpath, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
            AttributeExpressionImpl sourceExpression = inputXPath == null ? this.parseOgcCqlExpression(sourceExpr) : new AttributeExpressionImpl(inputXPath, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces));
            Map clientProperties = this.getClientProperties(attDto, itemXpath);
            if (expectedInstanceTypeName != null) {
                Name expectedNodeTypeName = this.degloseTypeName(expectedInstanceTypeName);
                expectedInstanceOf = this.typeRegistry.getAttributeType(expectedNodeTypeName, null, null);
                if (expectedInstanceOf == null) {
                    String msg = "mapping expects and instance of " + expectedNodeTypeName + " for attribute " + targetXPath + " but the attribute descriptor was not found";
                    throw new DataSourceException(msg);
                }
            } else {
                expectedInstanceOf = null;
            }
            String sourceElement = attDto.getLinkElement();
            if (attDto.getLabel() != null || attDto.getParentLabel() != null) {
                attMapping = new TreeAttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, expectedInstanceOf, isMultiValued, clientProperties, attDto.getLabel(), attDto.getParentLabel(), attDto.getTargetQueryString(), attDto.getInstancePath());
            } else if (sourceElement != null) {
                String sourceField = attDto.getLinkField();
                assert (sourceField != null);
                XPath.StepList sourceFieldSteps = XPath.steps(root, sourceField, this.namespaces);
                attMapping = new NestedAttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, isMultiValued, clientProperties, this.degloseTypeName(sourceElement), sourceFieldSteps, this.namespaces);
            } else {
                attMapping = new AttributeMapping((Expression)idExpression, (Expression)sourceExpression, targetXPathSteps, expectedInstanceOf, isMultiValued, clientProperties);
            }
            attMappings.add(attMapping);
        }
        return attMappings;
    }

    private void validateConfiguredNamespaces(XPath.StepList targetXPathSteps) {
        Iterator it = targetXPathSteps.iterator();
        while (it.hasNext()) {
            XPath.Step step = (XPath.Step)it.next();
            QName name = step.getName();
            if ("".equals(name.getPrefix()) || !"".equals(name.getNamespaceURI())) continue;
            throw new IllegalArgumentException("location step " + step + " has prefix " + name.getPrefix() + " for which no namespace was set. " + "(Check the Namespaces section in the config file)");
        }
    }

    private Expression parseOgcCqlExpression(String sourceExpr) throws DataSourceException {
        Expression expression = Expression.NIL;
        if (sourceExpr != null && sourceExpr.trim().length() > 0) {
            try {
                expression = CQL.toExpression((String)sourceExpr);
            }
            catch (CQLException e) {
                String formattedErrorMessage = e.getMessage();
                LOGGER.log(Level.SEVERE, formattedErrorMessage, e);
                throw new DataSourceException("Error parsing CQL expression " + sourceExpr + ":\n" + formattedErrorMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "parsing expression " + sourceExpr;
                LOGGER.log(Level.SEVERE, msg, e);
                throw new DataSourceException(msg + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return expression;
    }

    private Map getClientProperties(org.geotools.data.complex.config.AttributeMapping dto, String inputXPath) throws DataSourceException {
        if (dto.getClientProperties().size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Name, Expression> clientProperties = new HashMap<Name, Expression>();
        for (Map.Entry entry : dto.getClientProperties().entrySet()) {
            String name = (String)entry.getKey();
            Name qName = this.degloseName(name);
            String cqlExpression = (String)entry.getValue();
            Object expression = inputXPath == null ? this.parseOgcCqlExpression(cqlExpression) : (cqlExpression.startsWith("'") ? new AttributeExpressionImpl(cqlExpression, null) : new AttributeExpressionImpl(cqlExpression, new Hints((RenderingHints.Key)FeaturePropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaces)));
            clientProperties.put(qName, (Expression)expression);
        }
        return clientProperties;
    }

    private FeatureSource getFeatureSource(TypeMapping dto) throws IOException {
        String dsId = dto.getSourceDataStore();
        String typeName = dto.getSourceTypeName();
        DataAccess sourceDataStore = (DataAccess)this.sourceDataStores.get(dsId);
        if (sourceDataStore == null) {
            throw new DataSourceException("datastore " + dsId + " not found for type mapping " + dto);
        }
        LOGGER.fine("asking datastore " + sourceDataStore + " for source type " + typeName);
        Name name = this.degloseName(typeName);
        FeatureSource<FeatureType, Feature> fSource = sourceDataStore.getFeatureSource(name);
        if (this.inputDataAccessIds.contains(dsId)) {
            fSource = DataAccessRegistry.getFeatureSource(fSource.getName());
            this.sourceDataStores.put(dsId, fSource.getDataStore());
        }
        LOGGER.fine("found feature source for " + typeName);
        return fSource;
    }

    private void parseGmlSchemas() throws IOException {
        LOGGER.finer("about to parse target schemas");
        URL baseUrl = new URL(this.config.getBaseSchemasUrl());
        List schemaFiles = this.config.getTargetSchemasUris();
        Catalog oasisCatalog = this.getCatalog();
        EmfAppSchemaReader schemaParser = EmfAppSchemaReader.newInstance();
        schemaParser.setCatalog(oasisCatalog);
        this.typeRegistry = new FeatureTypeRegistry(this.namespaces);
        for (String schemaLocation : schemaFiles) {
            URL schemaUrl = this.resolveResourceLocation(baseUrl, schemaLocation);
            LOGGER.fine("parsing schema " + schemaUrl.toExternalForm());
            SchemaIndex schemaIndex = schemaParser.parse(schemaUrl, this.resolvedSchemaLocations);
            this.typeRegistry.addSchemas(schemaIndex);
        }
    }

    private Catalog getCatalog() throws MalformedURLException, IOException {
        String catalogLocation = this.config.getCatalog();
        if (catalogLocation == null) {
            return null;
        }
        URL baseUrl = new URL(this.config.getBaseSchemasUrl());
        URL resolvedCatalogLocation = this.resolveResourceLocation(baseUrl, catalogLocation);
        return CatalogUtilities.buildPrivateCatalog(resolvedCatalogLocation);
    }

    private URL resolveResourceLocation(URL baseUrl, String schemaLocation) throws MalformedURLException {
        URL schemaUrl;
        if (schemaLocation.startsWith("file:") || schemaLocation.startsWith("http:")) {
            LOGGER.fine("using resource location as absolute path: " + schemaLocation);
            schemaUrl = new URL(schemaLocation);
        } else if (baseUrl == null) {
            schemaUrl = new URL(schemaLocation);
            LOGGER.warning("base url not provided, may be unable to locate" + schemaLocation + ". Path resolved to: " + schemaUrl.toExternalForm());
        } else {
            LOGGER.fine("using schema location " + schemaLocation + " as relative to " + baseUrl);
            schemaUrl = new URL(baseUrl, schemaLocation);
        }
        return schemaUrl;
    }

    private Map aquireSourceDatastores() throws IOException {
        LOGGER.entering(this.getClass().getName(), "aquireSourceDatastores");
        HashMap<String, DataAccess> datastores = new HashMap<String, DataAccess>();
        List dsParams = this.config.getSourceDataStores();
        for (SourceDataStore dsconfig : dsParams) {
            String id = dsconfig.getId();
            if (dsconfig.isDataAccess()) {
                this.inputDataAccessIds.add(id);
            }
            Map datastoreParams = dsconfig.getParams();
            datastoreParams = this.resolveRelativePaths(datastoreParams);
            LOGGER.fine("looking for datastore " + id);
            DataAccess dataStore = DataAccessFinder.getDataStore((Map)datastoreParams);
            if (dataStore == null) {
                throw new DataSourceException("Cannot find a DataAccess for parameters " + datastoreParams);
            }
            LOGGER.fine("got datastore " + dataStore);
            datastores.put(id, dataStore);
        }
        return datastores;
    }

    private Map resolveRelativePaths(Map datastoreParams) {
        HashMap<String, String> resolvedParams = new HashMap<String, String>();
        for (Map.Entry entry : datastoreParams.entrySet()) {
            File f;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null && value.startsWith("file:") && !(f = new File(value = value.substring("file:".length()))).isAbsolute()) {
                LOGGER.fine("resolving relative path " + value + " for dataURLstore parameter " + key);
                try {
                    URL baseSchemasUrl = new URL(this.config.getBaseSchemasUrl());
                    URL resolvedUrl = new URL(baseSchemasUrl, value);
                    value = "url".equals(key) ? resolvedUrl.toExternalForm() : DataUtilities.urlToFile((URL)resolvedUrl).getPath();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                LOGGER.fine("new value for " + key + ": " + value);
            }
            resolvedParams.put(key, value);
        }
        return resolvedParams;
    }

    private Name degloseTypeName(String prefixedName) throws IllegalArgumentException {
        Name name = null;
        if (prefixedName == null) {
            return null;
        }
        int prefixIdx = prefixedName.indexOf(58);
        if (prefixIdx == -1) {
            return Types.typeName(prefixedName);
        }
        String nsPrefix = prefixedName.substring(0, prefixIdx);
        String localName = prefixedName.substring(prefixIdx + 1);
        String nsUri = this.namespaces.getURI(nsPrefix);
        name = Types.typeName(nsUri, localName);
        return name;
    }

    private Name degloseName(String prefixedName) throws IllegalArgumentException {
        Name name = null;
        if (prefixedName == null) {
            return null;
        }
        int prefixIdx = prefixedName.indexOf(58);
        if (prefixIdx == -1) {
            return Types.typeName(prefixedName);
        }
        String nsPrefix = prefixedName.substring(0, prefixIdx);
        String localName = prefixedName.substring(prefixIdx + 1);
        String nsUri = this.namespaces.getURI(nsPrefix);
        name = Types.typeName(nsUri, localName);
        return name;
    }
}

