/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.geotools.util.logging.Logging;

public class CatalogUtilities {
    private static final Logger LOGGER = Logging.getLogger((String)CatalogUtilities.class.getPackage().getName());

    public static String resolveSchemaLocation(Catalog catalog, String location) {
        String schemaLocation;
        block7: {
            if (catalog == null) {
                return null;
            }
            schemaLocation = null;
            try {
                LOGGER.finest("resolving " + location);
                schemaLocation = catalog.resolveURI(location);
                if (schemaLocation == null) break block7;
                LOGGER.finer("Verifying existence of catalog resolved location " + schemaLocation);
                try {
                    File f = new File(new URI(schemaLocation));
                    if (!f.exists()) {
                        LOGGER.info("Cannot locate " + schemaLocation);
                        schemaLocation = null;
                    }
                }
                catch (URISyntaxException e) {
                    schemaLocation = null;
                    LOGGER.log(Level.WARNING, "Exception resolving " + schemaLocation, e);
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return schemaLocation;
    }

    public static Catalog buildPrivateCatalog(URL catalogLocation) {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setUseStaticCatalog(false);
        catalogManager.setVerbosity(0);
        catalogManager.setIgnoreMissingProperties(true);
        Catalog catalog = catalogManager.getCatalog();
        try {
            catalog.parseCatalog(catalogLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Error trying to load OASIS catalog from URL " + catalogLocation.toString(), e);
        }
        return catalog;
    }
}

