/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.xml.resolver.Catalog;
import org.geotools.data.complex.config.CatalogApplicationSchemaConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfAppSchemaReader {
    private static final Logger LOGGER = Logging.getLogger((String)EmfAppSchemaReader.class.getPackage().getName());
    private Catalog oasisCatalog;

    private EmfAppSchemaReader() {
    }

    public Catalog getCatalog() {
        return this.oasisCatalog;
    }

    public void setCatalog(Catalog oasisCatalog) {
        this.oasisCatalog = oasisCatalog;
    }

    public SchemaIndex parse(Configuration configuration) throws IOException {
        SchemaIndex appSchemaIndex = Schemas.findSchemas((Configuration)configuration);
        return appSchemaIndex;
    }

    public SchemaIndex parse(URL location, Map<String, String> resolvedSchemaLocations) throws IOException {
        String nameSpace = this.findSchemaNamespace(location);
        String schemaLocation = location.toExternalForm();
        if (resolvedSchemaLocations != null) {
            resolvedSchemaLocations.put(nameSpace, schemaLocation);
        }
        Catalog catalog = this.getCatalog();
        CatalogApplicationSchemaConfiguration configuration = new CatalogApplicationSchemaConfiguration(nameSpace, schemaLocation, catalog);
        return this.parse(configuration);
    }

    private String findSchemaNamespace(URL location) throws IOException {
        String resolvedLocation;
        String targetNamespace = null;
        if (this.getCatalog() != null && (resolvedLocation = this.getCatalog().resolveURI(location.toExternalForm())) != null) {
            location = new URL(resolvedLocation);
        }
        InputStream input = location.openStream();
        XmlPullParser parser = null;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            parser = factory.newPullParser();
            parser.setInput(input, "UTF-8");
            parser.nextTag();
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                if (!"targetNamespace".equals(parser.getAttributeName(i))) continue;
                targetNamespace = parser.getAttributeValue(i);
                break;
            }
            parser.setInput(null);
        }
        catch (XmlPullParserException e) {
            String msg = "Cannot find target namespace for schema document " + location;
            throw (RuntimeException)new RuntimeException(msg).initCause(e);
        }
        finally {
            input.close();
        }
        if (targetNamespace == null) {
            throw new IllegalArgumentException("Input document does not specifies a targetNamespace");
        }
        return targetNamespace;
    }

    public static EmfAppSchemaReader newInstance() {
        return new EmfAppSchemaReader();
    }
}

