/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.config;

import java.util.ArrayList;
import java.util.Collection;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.ComplexTypeProxy;
import org.geotools.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.feature.type.ComplexFeatureTypeImpl;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonFeatureTypeProxy
extends ComplexTypeProxy
implements FeatureType {
    private final Collection<PropertyDescriptor> descriptors;
    private final ComplexType subject;

    public NonFeatureTypeProxy(ComplexType type, FeatureTypeMapping mapping) {
        super(type.getName(), null);
        this.subject = type;
        int maxOccurs = mapping.getTargetFeature().getMaxOccurs();
        int minOccurs = mapping.getTargetFeature().getMinOccurs();
        boolean nillable = mapping.getTargetFeature().isNillable();
        Object defaultValue = mapping.getTargetFeature().getDefaultValue();
        Name name = mapping.getTargetFeature().getName();
        ComplexFeatureTypeFactoryImpl typeFactory = new ComplexFeatureTypeFactoryImpl();
        AttributeDescriptor descriptor = typeFactory.createAttributeDescriptor(this, name, minOccurs, maxOccurs, nillable, defaultValue);
        mapping.setTargetFeature(descriptor);
        this.descriptors = new ArrayList<PropertyDescriptor>(this.subject.getDescriptors()){
            {
                this.add(ComplexFeatureTypeImpl.FEATURE_CHAINING_LINK);
            }
        };
    }

    @Override
    public AttributeType getSubject() {
        return this.subject;
    }

    @Override
    public PropertyDescriptor getDescriptor(Name name) {
        if (name.equals(ComplexFeatureTypeImpl.FEATURE_CHAINING_LINK_NAME)) {
            return ComplexFeatureTypeImpl.FEATURE_CHAINING_LINK;
        }
        return super.getDescriptor(name);
    }

    @Override
    public Collection<PropertyDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public Collection<PropertyDescriptor> getTypeDescriptors() {
        return this.subject.getDescriptors();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public GeometryDescriptor getGeometryDescriptor() {
        return null;
    }
}

